package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bid.constants.BidCommonContants;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.TenderFundsMapper;
import com.ejianc.business.bid.bean.TenderFundsEntity;
import com.ejianc.business.bid.service.ITenderFundsService;

import java.util.Date;
import java.util.List;

/**
 * 投标管理-投标保证金
 * 
 * @author generator
 * 
 */
@Service("tenderFundsService")
public class TenderFundsServiceImpl extends BaseServiceImpl<TenderFundsMapper, TenderFundsEntity> implements ITenderFundsService{

    @Override
    public List<TenderFundsEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<TenderFundsEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");

        return super.list(query);
    }

    @Override
    public void saveQuoteBillId(Long id, Long quoteBillId) {
        TenderFundsEntity e  = super.selectById(id);
        e.setFundsBackId(null == quoteBillId ? Long.valueOf(BidCommonContants.STRING_NO) : quoteBillId);
        super.saveOrUpdate(e, false);
    }

    @Override
    public void delAllQuoteBillId(List<Long> quoteBillIds) {
        UpdateWrapper<TenderFundsEntity> update = new UpdateWrapper<>();
        update.in("funds_back_id", quoteBillIds);
        update.set("funds_back_id", Long.valueOf(BidCommonContants.STRING_NO));
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }

    @Override
    public void changeBusinessStatus(List<Long> ids, String status) {
        UpdateWrapper<TenderFundsEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("bounds_status", status);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());
        super.update(update);
    }
}
