package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-员工入职审批表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_employee_into")
public class EmployeeIntoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 员工编号
    @TableField(value="name")
    private String name; // 员工名称
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="age")
    private Integer age; // 年龄
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="dept_id")
    private Long deptId; // 部门ID
    @TableField(value="dept_name")
    private String deptName; // 部门
    @TableField(value="post_id")
    private Long postId; // 主职ID
    @TableField(value="post_name")
    private String postName; // 主职
    @TableField(value="rank")
    private Integer rank; // 职级
    @TableField(value="rank_name")
    private String rankName; // 职级
    @TableField(value="nation")
    private String nation; // 民族
    @TableField(value="height")
    private String height; // 身高
    @TableField(value="birth_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    @TableField(value="into_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @TableField(value="try_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDate; // 试用日期
    @TableField(value="origin")
    private String origin; // 籍贯
    @TableField(value="politics_id")
    private Integer politicsId; // 政治面貌
    @TableField(value="politics_name")
    private String politicsName; // 政治面貌
    @TableField(value="marital_status_id")
    private Integer maritalStatusId; // 婚姻状况
    @TableField(value="marital_status_name")
    private String maritalStatusName; // 婚姻状况
    @TableField(value="graduate_school")
    private String graduateSchool; // 毕业院校
    @TableField(value="major")
    private String major; // 所学专业
    @TableField(value="educated")
    private String educated; // 最高学历
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="id_address")
    private String idAddress; // 身份证地址
    @TableField(value="now_address")
    private String nowAddress; // 现居住地址
    @TableField(value="winter_num")
    private BigDecimal winterNum; // 冬季工时
    @TableField(value="summer_num")
    private BigDecimal summerNum; // 夏季工时
    @TableField(value="phone")
    private String phone; // 移动电话
    @TableField(value="email")
    private String email; // 邮箱
    @TableField(value="urgent_name")
    private String urgentName; // 紧急联系人姓名
    @TableField(value="urgent_relational")
    private String urgentRelational; // 紧急联系人关系
    @TableField(value="urgent_phone")
    private String urgentPhone; // 紧急联系人电话
    @TableField(value="salary")
    private BigDecimal salary; // 薪资标准
    @TableField(value="basic_salary")
    private BigDecimal basicSalary; // 基本薪资
    @TableField(value="post_salary")
    private BigDecimal postSalary; // 岗位薪资
    @TableField(value="level_salary")
    private BigDecimal levelSalary; // 层级薪资
    @TableField(value="try_standard")
    private String tryStandard; // 试用标准
    @TableField(value="insured_flag")
    private Integer insuredFlag; // 是否缴纳保险
    @TableField(value="insured_flag_name")
    private String insuredFlagName; // 是否缴纳保险
    @TableField(value="cert")
    private String cert; // 证书情况
    @TableField(value="cert_name")
    private String certName; // 证书情况
    @TableField(value="educated_salary")
    private BigDecimal educatedSalary; // 学历津贴
    @TableField(value="state")
    private Integer state; // 状态标识（0：离职，1：在职）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本

    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getTryDate() {
        return tryDate;
    }

    public void setTryDate(Date tryDate) {
        this.tryDate = tryDate;
    }
    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    public Integer getPoliticsId() {
        return politicsId;
    }

    public void setPoliticsId(Integer politicsId) {
        this.politicsId = politicsId;
    }
    public String getPoliticsName() {
        return politicsName;
    }

    public void setPoliticsName(String politicsName) {
        this.politicsName = politicsName;
    }

    public Integer getMaritalStatusId() {
        return maritalStatusId;
    }

    public void setMaritalStatusId(Integer maritalStatusId) {
        this.maritalStatusId = maritalStatusId;
    }

    public String getMaritalStatusName() {
        return maritalStatusName;
    }

    public void setMaritalStatusName(String maritalStatusName) {
        this.maritalStatusName = maritalStatusName;
    }

    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getIdAddress() {
        return idAddress;
    }

    public void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }
    public String getNowAddress() {
        return nowAddress;
    }

    public void setNowAddress(String nowAddress) {
        this.nowAddress = nowAddress;
    }
    public BigDecimal getWinterNum() {
        return winterNum;
    }

    public void setWinterNum(BigDecimal winterNum) {
        this.winterNum = winterNum;
    }
    public BigDecimal getSummerNum() {
        return summerNum;
    }

    public void setSummerNum(BigDecimal summerNum) {
        this.summerNum = summerNum;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
    public String getUrgentName() {
        return urgentName;
    }

    public void setUrgentName(String urgentName) {
        this.urgentName = urgentName;
    }
    public String getUrgentRelational() {
        return urgentRelational;
    }

    public void setUrgentRelational(String urgentRelational) {
        this.urgentRelational = urgentRelational;
    }
    public String getUrgentPhone() {
        return urgentPhone;
    }

    public void setUrgentPhone(String urgentPhone) {
        this.urgentPhone = urgentPhone;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public String getTryStandard() {
        return tryStandard;
    }

    public void setTryStandard(String tryStandard) {
        this.tryStandard = tryStandard;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public String getCert() {
        return cert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    
}
