package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contract.bean.ContractChangeEntity;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.bean.ContractRecordEntity;
import com.ejianc.business.contract.service.IContractChangeService;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.service.IContractRecordService;
import com.ejianc.business.contract.vo.ContractManageVO;
import com.ejianc.business.oa.bean.EmployeeIntoChangeEntity;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.bean.EmployeeIntoRecordEntity;
import com.ejianc.business.oa.service.IEmployeeIntoChangeService;
import com.ejianc.business.oa.service.IEmployeeIntoRecordService;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.vo.EmployeeIntoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service("employeeIntoChange") 
public class EmployeeIntoChangeBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IEmployeeIntoChangeService changeService;

	@Autowired
	private IEmployeeIntoService employeeIntoService;


	@Autowired
	private IEmployeeIntoRecordService recordService;
	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		EmployeeIntoChangeEntity changeEntity = changeService.selectById(billId);
		/**复制合同表数据到记录表 begin */
		EmployeeIntoVO employeeIntoVO = BeanMapper.map(employeeIntoService.selectById(changeEntity.getEmployeeId()), EmployeeIntoVO.class);
		EmployeeIntoRecordEntity recordEntity = BeanMapper.map(employeeIntoVO, EmployeeIntoRecordEntity.class);
		recordEntity.setEmployeeId(recordEntity.getId());
		recordEntity.setId(null);
		recordService.saveOrUpdate(recordEntity, false);
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(recordEntity.getEmployeeId()),"BT202411000023","photo", String.valueOf(recordEntity.getId()), "BT202411000025","photo");
		/**复制合同表数据到记录表 end */

		/**更新变更表表头数据到合同 begin */
		EmployeeIntoEntity entity = BeanMapper.map(changeEntity, EmployeeIntoEntity.class);
		entity.setId(changeEntity.getEmployeeId());
		entity.setChangeStatus(3);
		boolean b = employeeIntoService.updateById(entity);
		attachmentApi.copyFiles(String.valueOf(billId), "BT202411000024","photo",String.valueOf(changeEntity.getEmployeeId()),"BT202411000023","photo",true);
		/**复制合同表数据到记录表 end */


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
