package com.ejianc.business.scene.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 现场监控-现场检查
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_check_bfyj")
public class CheckBfyjEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名
    @TableField(value="check_name")
    private String checkName; // 检查名称
    @TableField(value="check_type")
    private Long checkType; // 检查类型
    @TableField(value="check_type_name")
    private String checkTypeName; // 检查类型名称
    @TableField(value="check_attr")
    private Integer checkAttr; // 检查属性
    @TableField(value="check_attr_name")
    private String checkAttrName; // 检查属性
    @TableField(value="check_level")
    private Integer checkLevel; // 检查级别1项目2公司
    @TableField(value="check_id")
    private String checkId; // 检查人id
    @TableField(value="check_person")
    private String checkPerson; // 检查人
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查日期
    @TableField(value="reform_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reformFinishDate; // 整改完成日期
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 要求完成日期
    @TableField(value="reform_duty_id")
    private String reformDutyId; // 整改责任人id
    @TableField(value="reform_duty_person")
    private String reformDutyPerson; // 整改责任人
    @TableField(value="reform_status")
    private Integer reformStatus; // 整改状态
    @TableField(value="review_id")
    private String reviewId; // 复查人id
    @TableField(value="review_person")
    private String reviewPerson; // 复查人
    @TableField(value="review_item")
    private Integer reviewItem; // 复查项
    @TableField(value="reviewed_num")
    private Integer reviewedNum; // 已复查数量
    @TableField(value="notif_relevant_id")
    private String notifRelevantId; // 通知相关人员id
    @TableField(value="notif_relevant_person")
    private String notifRelevantPerson; // 通知相关人员
    @TableField(value="review_status")
    private Integer reviewStatus; // 复查状态：0-自由态，1-已提交
    @TableField(value="overdue_num")
    private Integer overdueNum; // 逾期数量
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="review_pass")
    private Integer reviewPass; // 复查合格的数量（已完成）
    @TableField(value="import_ts")
    private Long importTs; // 导入时间戳
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="checkDetailBfyjService")
    private List<CheckDetailBfyjEntity> sceneCheckDetails = new ArrayList<>(); // 现场监控-现场检查-检查单待检复检子表

    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    public Long getCheckType() {
        return checkType;
    }

    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }
    public String getCheckAttrName() {
        return checkAttrName;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }
    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
    }
    public String getCheckId() {
        return checkId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getReformFinishDate() {
        return reformFinishDate;
    }

    public void setReformFinishDate(Date reformFinishDate) {
        this.reformFinishDate = reformFinishDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public String getReformDutyId() {
        return reformDutyId;
    }

    public void setReformDutyId(String reformDutyId) {
        this.reformDutyId = reformDutyId;
    }
    public String getReformDutyPerson() {
        return reformDutyPerson;
    }

    public void setReformDutyPerson(String reformDutyPerson) {
        this.reformDutyPerson = reformDutyPerson;
    }
    public Integer getReformStatus() {
        return reformStatus;
    }

    public void setReformStatus(Integer reformStatus) {
        this.reformStatus = reformStatus;
    }
    public String getReviewId() {
        return reviewId;
    }

    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }
    public String getReviewPerson() {
        return reviewPerson;
    }

    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }
    public Integer getReviewItem() {
        return reviewItem;
    }

    public void setReviewItem(Integer reviewItem) {
        this.reviewItem = reviewItem;
    }
    public Integer getReviewedNum() {
        return reviewedNum;
    }

    public void setReviewedNum(Integer reviewedNum) {
        this.reviewedNum = reviewedNum;
    }
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }
    public Integer getOverdueNum() {
        return overdueNum;
    }

    public void setOverdueNum(Integer overdueNum) {
        this.overdueNum = overdueNum;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getReviewPass() {
        return reviewPass;
    }

    public void setReviewPass(Integer reviewPass) {
        this.reviewPass = reviewPass;
    }
    public Long getImportTs() {
        return importTs;
    }

    public void setImportTs(Long importTs) {
        this.importTs = importTs;
    }


    public List<CheckDetailBfyjEntity> getSceneCheckDetails() {
        return sceneCheckDetails;
    }

    public void setSceneCheckDetails(List<CheckDetailBfyjEntity> sceneCheckDetails) {
        this.sceneCheckDetails = sceneCheckDetails;
    }
}
