package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.oa.bean.InstoreDetailEntity;
import com.ejianc.business.oa.service.IInstoreDetailService;
import com.ejianc.business.oa.utlis.ArchivesUtil;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.vo.InstoreVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 人力行政-资产入库单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("instore")
public class InstoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ArchivesUtil archivesUtil;

    private static final String BILL_CODE = "OA_INSTORE";//此处需要根据实际修改

    @Autowired
    private IInstoreService service;
    @Autowired
    private IInstoreDetailService instoreDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InstoreVO> saveOrUpdate(@RequestBody InstoreVO saveOrUpdateVO) {
    	InstoreEntity entity = BeanMapper.map(saveOrUpdateVO, InstoreEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<InstoreDetailEntity> detailList = entity.getDetailList();
        List<InstoreDetailEntity> newMaterialList = detailList.stream().filter(e -> null != e.getSourceType() && "0".equals(e.getSourceType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newMaterialList)) {
            for (InstoreDetailEntity instoreMaterialEntity : newMaterialList) {
                String onlykey = instoreMaterialEntity.getMaterialCategoryName() + instoreMaterialEntity.getMaterialName() + instoreMaterialEntity.getMaterialUnit() + instoreMaterialEntity.getMaterialSpec() + instoreMaterialEntity.getMaterialCode();
                instoreMaterialEntity.setOnlyKey(onlykey);
            }
            JSONObject jsonObject = archivesUtil.batchSaveArchive(newMaterialList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "materialCode", "materialUnit", "materialSpec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<InstoreDetailEntity> list = JSONObject.parseArray(sourceList, InstoreDetailEntity.class);
            entity.setDetailList(list);
            entity.getDetailList().addAll(detailList.stream().filter(e -> null != e.getSourceType() && "1".equals(e.getSourceType())).collect(Collectors.toList()));
        }
    	service.saveOrUpdate(entity, false);
    	InstoreVO vo = BeanMapper.map(entity, InstoreVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InstoreVO> queryDetail(Long id) {
    	InstoreEntity entity = service.selectById(id);
    	InstoreVO vo = BeanMapper.map(entity, InstoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstoreVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InstoreVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InstoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","orgName","storeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<InstoreEntity> page = service.queryPage(param,false);
        IPage<InstoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InstoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode","orgName","storeName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InstoreEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<InstoreVO> voList = BeanMapper.mapList(list, InstoreVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Instore-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInstoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> refInstoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InstoreEntity> page = service.queryPage(param,false);
        IPage<InstoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InstoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 根据入库子表计算该入库子表出库时候可用数量
     * @param inStoreSubId
     * @param materialId
     * @param outSubId
     * @return
     */
    @RequestMapping(value = "calculateCanUseNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success("计算可用库存成功！", service.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }




    /**
     * 查询库存可用数量参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @param searchObject
     * @return
     */
    @RequestMapping(value = "refCanUseNumData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InstoreDetailVO>> refCanUseNumData(@RequestParam Integer pageNumber,
                                                                   @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchText, String searchObject) {
        if (StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询条件condition不能为空");
        }
        JSONObject con = JSONObject.parseObject(condition);
        if (StringUtils.isBlank(con.getString("storeId"))) {
            return CommonResponse.error("查询条件【仓库】不能为空");
        }
        if (StringUtils.isBlank(con.getString("outDate"))) {
            return CommonResponse.error("查询条件【出库日期】不能为空");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter(QueryParam.EQ, con.getString("storeId")));
        queryParam.getParams().put("instoreDate", new Parameter(QueryParam.LE, con.getString("outDate")));

        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        IPage<InstoreDetailVO> pageVo = new Page<>();
        IPage<InstoreDetailVO> entityPage =
                instoreDetailService.queryStoreCanUseNumPageData(
                        searchText,
                        searchObject,
                        con.getString("outDate"),
                        con.getLong("storeId"), pageNumber, pageSize);
        if (entityPage != null) {
            List<InstoreDetailVO> voList = new ArrayList<>();
            entityPage.getRecords().forEach(e -> {
                InstoreDetailVO vo = BeanMapper.map(e, InstoreDetailVO.class);
                vo.setCanUseNumber(service.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize(queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success("查询出库可用物资参照成功！", entityPage);
    }




    /**
     * 库存表
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryStoreData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryStoreData(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        QueryWrapper<InstoreDetailVO> queryWrapper = changeToQueryWrapper(param);
        Page<InstoreDetailEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<InstoreDetailVO> pageData = instoreDetailService.queryStoreData(page, queryWrapper);

        JSONObject res = new JSONObject();
        res.put("records", pageData);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

}
