package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.oa.bean.InstoreEntity;
import com.ejianc.business.oa.bean.OutstoreDetailEntity;
import com.ejianc.business.oa.bean.OutstoreEntity;
import com.ejianc.business.oa.service.IInstoreService;
import com.ejianc.business.oa.service.IOutstoreService;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import com.ejianc.business.oa.vo.InstoreVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service("outstore") 
public class OutstoreBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IOutstoreService outstoreService;
	@Autowired
	private IInstoreService instoreService;
	@Autowired
	private IBillCodeApi billCodeApi;

	@Autowired
	private IBillTypeApi billTypeApi;
	private static final String BILL_CODE = "OA_INSTORE";//此处需要根据实际修改
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutstoreEntity entity = outstoreService.selectById(billId);
		if(Objects.equals(entity.getOutStoreType(), 0)){//调拨出库
			InstoreVO vo = new InstoreVO();
			BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if(billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}

			vo.setId(IdWorker.getId());
			vo.setOrgId(entity.getInOrgId());
			vo.setOrgCode(entity.getInOrgCode());
			vo.setOrgName(entity.getInOrgName());
			vo.setStoreId(entity.getInStoreId());
			vo.setStoreName(entity.getInStoreName());
			vo.setInstoreDate(entity.getInStoreDate());
			vo.setMainSourceId(entity.getId());
			vo.setMainSourceType("1");
			vo.setMemo(entity.getMemo());
			vo.setEmployeeId(entity.getEmployeeId());
			vo.setEmployeeName(entity.getEmployeeName());
			vo.setBillState(1);

			List<InstoreDetailVO> instoreDetailVOList = vo.getDetailList();
			List<OutstoreDetailEntity> outStoreSubs =entity.getDetailList();
			if(!ListUtil.isEmpty(outStoreSubs)){
				for (OutstoreDetailEntity outStoreSub : outStoreSubs) {
					InstoreDetailVO detailVO = new InstoreDetailVO();
					detailVO.setId(null);
					detailVO.setVersion(null);

					detailVO.setInstoreId(vo.getId());
					detailVO.setStoreId(vo.getStoreId());
					detailVO.setStoreName(vo.getStoreName());
					detailVO.setInstoreDate(vo.getInstoreDate());
					detailVO.setMaterialCategoryId(outStoreSub.getMaterialCategoryId());
					detailVO.setMaterialCategoryName(outStoreSub.getMaterialCategoryName());
					detailVO.setMaterialId(outStoreSub.getMaterialId());
					detailVO.setMaterialCode(outStoreSub.getMaterialCode());
					detailVO.setMaterialName(outStoreSub.getMaterialName());
					detailVO.setMaterialSpec(outStoreSub.getMaterialSpec());
					detailVO.setMaterialUnit(outStoreSub.getMaterialUnit());
					detailVO.setInstoreNumber(outStoreSub.getOutStoreNumber());
					detailVO.setResidueNumber(outStoreSub.getOutStoreNumber());
					detailVO.setUnitPrice(outStoreSub.getUnitPrice());
					detailVO.setTaxRate(outStoreSub.getTaxRate());
					detailVO.setAmount(outStoreSub.getAmount());
					detailVO.setRemark(outStoreSub.getRemark());
					detailVO.setSourceType("2");
					instoreDetailVOList.add(detailVO);

				}
			}
			logger.info("生成新的入库单-{}", JSONObject.toJSONString(vo));
			instoreService.saveOrUpdate(BeanMapper.map(vo, InstoreEntity.class),false);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("弃审前事件回调-------------------");
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if (!resp.isSuccess()) {
			return CommonResponse.error(resp.getMsg());
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
