package com.ejianc.business.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.QueryChainWrapper;
import com.ejianc.business.project.bean.InSiteEntity;
import com.ejianc.business.project.mapper.InSiteMapper;
import com.ejianc.business.project.service.IInSiteService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.List;


/**
 * 项目基本信息管理-人员派遣实体
 * 
 * @author generator
 * 
 */
@Service("inSiteService")
public class InSiteServiceImpl extends BaseServiceImpl<InSiteMapper, InSiteEntity> implements IInSiteService {

    @Override
    public void updateRefBillId(Long onSiteId, Long refBillId, boolean updateRefBill) {
        List<InSiteEntity> updateList = new ArrayList<>();
        
        InSiteEntity oldRefEntity = getByRefBillId(refBillId);
        if(null != oldRefEntity) {
            oldRefEntity.setRefBillId(null);
            updateList.add(oldRefEntity);
        }
        if(null != onSiteId) {
            InSiteEntity entity = super.selectById(onSiteId);
            entity.setRefBillId(refBillId);
            updateList.add(entity);
        }
        if(CollectionUtils.isNotEmpty(updateList)) {
            super.saveOrUpdateBatch(updateList, updateList.size(), false);
        }

    }

    @Override
    public void deleteRefIds(List<Long> refBillIds) {
        UpdateWrapper<InSiteEntity> update = new UpdateWrapper<>();
        update.in("ref_bill_id", refBillIds);
        update.eq("dr", BaseVO.DR_UNDELETE);

        update.set("ref_bill_id", null);

        super.update(update);
    }

    private InSiteEntity getByRefBillId(Long refBillId) {
        QueryWrapper<InSiteEntity> query = new QueryWrapper<>();
        query.eq("ref_bill_id", refBillId);
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }
}
