package com.ejianc.business.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 成本会计-项目对账单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_cost_project_bill")
public class ProjectBillEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额
    @TableField(value="charging_refer_mny")
    private BigDecimal chargingReferMny; // 计费依据
    @TableField(value="tax_levy_rate")
    private BigDecimal taxLevyRate; // 税金征收率
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="dif_place_advance_tax")
    private BigDecimal difPlaceAdvanceTax; // 异地预缴税额
    @TableField(value="already_pay_tax")
    private BigDecimal alreadyPayTax; // 已交税金
    @TableField(value="total_pay_tax")
    private BigDecimal totalPayTax; // 累计已交税金
    @TableField(value="already_deduct_tax")
    private BigDecimal alreadyDeductTax; // 本次抵扣税额
    @TableField(value="total_deduct_tax")
    private BigDecimal totalDeductTax; // 累计抵扣税额
    @TableField(value="project_dept_tax")
    private BigDecimal projectDeptTax; // 项目部应缴税小计
    @TableField(value="management_fee_rate")
    private BigDecimal managementFeeRate; // 管理费征收率
    @TableField(value="management_fee_mny")
    private BigDecimal managementFeeMny; // 管理费金额
    @TableField(value="no_cost_ticket_levy")
    private BigDecimal noCostTicketLevy; // 无成本票预留
    @TableField(value="no_cost_ticket_reserved_levy_rate")
    private BigDecimal noCostTicketReservedLevyRate; // 无成本票预留征收率
    @TableField(value="no_cost_ticket_reserved_levy_mny")
    private BigDecimal noCostTicketReservedLevyMny; // 无成本票预留
    @TableField(value="other_chargeable_mny")
    private BigDecimal otherChargeableMny; // 其他应收费用
    @TableField(value="project_dept_chargeable_mny")
    private BigDecimal projectDeptChargeableMny; // 项目部应交费小计
    @TableField(value="repayment_mny")
    private BigDecimal repaymentMny; // 本次回款金额
    @TableField(value="total_repayment_mny")
    private BigDecimal totalRepaymentMny; // 累计回款金额
    @TableField(value="bill_mny")
    private BigDecimal billMny; // 本次对账金额
    @TableField(value="last_repayment_tax")
    private BigDecimal lastRepaymentTax; // 上次结余税额
    @TableField(value="deduct_tax")
    private BigDecimal deductTax; // 新增可抵扣税额
    @TableField(value="total_can_deduct_tax")
    private BigDecimal totalCanDeductTax; // 累计可抵扣税额
    @TableField(value="deduct_tax_collect")
    private BigDecimal deductTaxCollect; // 现有抵扣税额合计
    @TableField(value="deduct_tax_collect_cash")
    private BigDecimal deductTaxCollectCash; // 现有抵扣税额合计转现金
    @TableField(value="leave_deduct_tax")
    private BigDecimal leaveDeductTax; // 剩余可抵扣税额
    @TableField(value="need_cost")
    private BigDecimal needCost; // 本次需提供成本
    @TableField(value="cost_collect")
    private BigDecimal costCollect; // 现有成本合计
    @TableField(value="use_cost")
    private BigDecimal useCost; // 本次使用成本
    @TableField(value="leave_usable_cost")
    private BigDecimal leaveUsableCost; // 剩余可用成本
    @TableField(value="last_balance_cost")
    private BigDecimal lastBalanceCost; // 上次结余成本
    @TableField(value="special_ticket_cost")
    private BigDecimal specialTicketCost; // 新增专票成本
    @TableField(value="total_special_ticket_cost")
    private BigDecimal totalSpecialTicketCost; // 累计专票成本
    @TableField(value="common_ticket_mny")
    private BigDecimal commonTicketMny; // 新增普票成本
    @TableField(value="total_common_ticket_mny")
    private BigDecimal totalCommonTicketMny; // 累计普票成本
    @TableField(value="migrant_worker_cash_cost")
    private BigDecimal migrantWorkerCashCost; // 新增农民工工资成本
    @TableField(value="total_migrant_worker_cash_cost")
    private BigDecimal totalMigrantWorkerCashCost; // 累计农民工工资成本
    @TableField(value="deduct_limit")
    private BigDecimal deductLimit; // 本次抵扣上限（含预缴）
    @TableField(value="wait_pass_cost")
    private BigDecimal waitPassCost; // 待合格成本
    @TableField(value="wait_pass_deduct_tax")
    private BigDecimal waitPassDeductTax; // 待合格抵扣税额
    @TableField(value="invoice_mny")
    private BigDecimal invoiceMny; // 本次开票金额
    @TableField(value="total_invoice_mny")
    private BigDecimal totalInvoiceMny; // 累计开票金额
    @TableField(value="total_payment_mny")
    private BigDecimal totalPaymentMny; // 累计回款金额
    @TableField(value="contract_payment_rate")
    private BigDecimal contractPaymentRate; // 合同回款比例
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getChargingReferMny() {
        return chargingReferMny;
    }

    public void setChargingReferMny(BigDecimal chargingReferMny) {
        this.chargingReferMny = chargingReferMny;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getDifPlaceAdvanceTax() {
        return difPlaceAdvanceTax;
    }

    public void setDifPlaceAdvanceTax(BigDecimal difPlaceAdvanceTax) {
        this.difPlaceAdvanceTax = difPlaceAdvanceTax;
    }
    public BigDecimal getAlreadyPayTax() {
        return alreadyPayTax;
    }

    public void setAlreadyPayTax(BigDecimal alreadyPayTax) {
        this.alreadyPayTax = alreadyPayTax;
    }
    public BigDecimal getTotalPayTax() {
        return totalPayTax;
    }

    public void setTotalPayTax(BigDecimal totalPayTax) {
        this.totalPayTax = totalPayTax;
    }
    public BigDecimal getAlreadyDeductTax() {
        return alreadyDeductTax;
    }

    public void setAlreadyDeductTax(BigDecimal alreadyDeductTax) {
        this.alreadyDeductTax = alreadyDeductTax;
    }
    public BigDecimal getTotalDeductTax() {
        return totalDeductTax;
    }

    public void setTotalDeductTax(BigDecimal totalDeductTax) {
        this.totalDeductTax = totalDeductTax;
    }
    public BigDecimal getProjectDeptTax() {
        return projectDeptTax;
    }

    public void setProjectDeptTax(BigDecimal projectDeptTax) {
        this.projectDeptTax = projectDeptTax;
    }
    public BigDecimal getManagementFeeRate() {
        return managementFeeRate;
    }

    public void setManagementFeeRate(BigDecimal managementFeeRate) {
        this.managementFeeRate = managementFeeRate;
    }
    public BigDecimal getManagementFeeMny() {
        return managementFeeMny;
    }

    public void setManagementFeeMny(BigDecimal managementFeeMny) {
        this.managementFeeMny = managementFeeMny;
    }
    public BigDecimal getNoCostTicketLevy() {
        return noCostTicketLevy;
    }

    public void setNoCostTicketLevy(BigDecimal noCostTicketLevy) {
        this.noCostTicketLevy = noCostTicketLevy;
    }
    public BigDecimal getNoCostTicketReservedLevyRate() {
        return noCostTicketReservedLevyRate;
    }

    public void setNoCostTicketReservedLevyRate(BigDecimal noCostTicketReservedLevyRate) {
        this.noCostTicketReservedLevyRate = noCostTicketReservedLevyRate;
    }
    public BigDecimal getNoCostTicketReservedLevyMny() {
        return noCostTicketReservedLevyMny;
    }

    public void setNoCostTicketReservedLevyMny(BigDecimal noCostTicketReservedLevyMny) {
        this.noCostTicketReservedLevyMny = noCostTicketReservedLevyMny;
    }
    public BigDecimal getOtherChargeableMny() {
        return otherChargeableMny;
    }

    public void setOtherChargeableMny(BigDecimal otherChargeableMny) {
        this.otherChargeableMny = otherChargeableMny;
    }
    public BigDecimal getProjectDeptChargeableMny() {
        return projectDeptChargeableMny;
    }

    public void setProjectDeptChargeableMny(BigDecimal projectDeptChargeableMny) {
        this.projectDeptChargeableMny = projectDeptChargeableMny;
    }
    public BigDecimal getRepaymentMny() {
        return repaymentMny;
    }

    public void setRepaymentMny(BigDecimal repaymentMny) {
        this.repaymentMny = repaymentMny;
    }
    public BigDecimal getTotalRepaymentMny() {
        return totalRepaymentMny;
    }

    public void setTotalRepaymentMny(BigDecimal totalRepaymentMny) {
        this.totalRepaymentMny = totalRepaymentMny;
    }
    public BigDecimal getBillMny() {
        return billMny;
    }

    public void setBillMny(BigDecimal billMny) {
        this.billMny = billMny;
    }
    public BigDecimal getLastRepaymentTax() {
        return lastRepaymentTax;
    }

    public void setLastRepaymentTax(BigDecimal lastRepaymentTax) {
        this.lastRepaymentTax = lastRepaymentTax;
    }
    public BigDecimal getDeductTax() {
        return deductTax;
    }

    public void setDeductTax(BigDecimal deductTax) {
        this.deductTax = deductTax;
    }
    public BigDecimal getTotalCanDeductTax() {
        return totalCanDeductTax;
    }

    public void setTotalCanDeductTax(BigDecimal totalCanDeductTax) {
        this.totalCanDeductTax = totalCanDeductTax;
    }
    public BigDecimal getDeductTaxCollect() {
        return deductTaxCollect;
    }

    public void setDeductTaxCollect(BigDecimal deductTaxCollect) {
        this.deductTaxCollect = deductTaxCollect;
    }
    public BigDecimal getDeductTaxCollectCash() {
        return deductTaxCollectCash;
    }

    public void setDeductTaxCollectCash(BigDecimal deductTaxCollectCash) {
        this.deductTaxCollectCash = deductTaxCollectCash;
    }
    public BigDecimal getLeaveDeductTax() {
        return leaveDeductTax;
    }

    public void setLeaveDeductTax(BigDecimal leaveDeductTax) {
        this.leaveDeductTax = leaveDeductTax;
    }
    public BigDecimal getNeedCost() {
        return needCost;
    }

    public void setNeedCost(BigDecimal needCost) {
        this.needCost = needCost;
    }
    public BigDecimal getCostCollect() {
        return costCollect;
    }

    public void setCostCollect(BigDecimal costCollect) {
        this.costCollect = costCollect;
    }
    public BigDecimal getUseCost() {
        return useCost;
    }

    public void setUseCost(BigDecimal useCost) {
        this.useCost = useCost;
    }
    public BigDecimal getLeaveUsableCost() {
        return leaveUsableCost;
    }

    public void setLeaveUsableCost(BigDecimal leaveUsableCost) {
        this.leaveUsableCost = leaveUsableCost;
    }
    public BigDecimal getLastBalanceCost() {
        return lastBalanceCost;
    }

    public void setLastBalanceCost(BigDecimal lastBalanceCost) {
        this.lastBalanceCost = lastBalanceCost;
    }
    public BigDecimal getSpecialTicketCost() {
        return specialTicketCost;
    }

    public void setSpecialTicketCost(BigDecimal specialTicketCost) {
        this.specialTicketCost = specialTicketCost;
    }
    public BigDecimal getTotalSpecialTicketCost() {
        return totalSpecialTicketCost;
    }

    public void setTotalSpecialTicketCost(BigDecimal totalSpecialTicketCost) {
        this.totalSpecialTicketCost = totalSpecialTicketCost;
    }
    public BigDecimal getCommonTicketMny() {
        return commonTicketMny;
    }

    public void setCommonTicketMny(BigDecimal commonTicketMny) {
        this.commonTicketMny = commonTicketMny;
    }
    public BigDecimal getTotalCommonTicketMny() {
        return totalCommonTicketMny;
    }

    public void setTotalCommonTicketMny(BigDecimal totalCommonTicketMny) {
        this.totalCommonTicketMny = totalCommonTicketMny;
    }
    public BigDecimal getMigrantWorkerCashCost() {
        return migrantWorkerCashCost;
    }

    public void setMigrantWorkerCashCost(BigDecimal migrantWorkerCashCost) {
        this.migrantWorkerCashCost = migrantWorkerCashCost;
    }
    public BigDecimal getTotalMigrantWorkerCashCost() {
        return totalMigrantWorkerCashCost;
    }

    public void setTotalMigrantWorkerCashCost(BigDecimal totalMigrantWorkerCashCost) {
        this.totalMigrantWorkerCashCost = totalMigrantWorkerCashCost;
    }
    public BigDecimal getDeductLimit() {
        return deductLimit;
    }

    public void setDeductLimit(BigDecimal deductLimit) {
        this.deductLimit = deductLimit;
    }
    public BigDecimal getWaitPassCost() {
        return waitPassCost;
    }

    public void setWaitPassCost(BigDecimal waitPassCost) {
        this.waitPassCost = waitPassCost;
    }
    public BigDecimal getWaitPassDeductTax() {
        return waitPassDeductTax;
    }

    public void setWaitPassDeductTax(BigDecimal waitPassDeductTax) {
        this.waitPassDeductTax = waitPassDeductTax;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    public BigDecimal getTotalPaymentMny() {
        return totalPaymentMny;
    }

    public void setTotalPaymentMny(BigDecimal totalPaymentMny) {
        this.totalPaymentMny = totalPaymentMny;
    }
    public BigDecimal getContractPaymentRate() {
        return contractPaymentRate;
    }

    public void setContractPaymentRate(BigDecimal contractPaymentRate) {
        this.contractPaymentRate = contractPaymentRate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
}
