package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.bean.CertHumanEntity;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.service.ICertHumanService;
import com.ejianc.business.oa.vo.CertHumanChangeVO;
import com.ejianc.business.oa.vo.EmployeeIntoChangeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertHumanChangeMapper;
import com.ejianc.business.oa.bean.CertHumanChangeEntity;
import com.ejianc.business.oa.service.ICertHumanChangeService;

/**
 * 人力行政-证书人员申请表-变更
 * 
 * @author generator
 * 
 */
@Service("certHumanChangeService")
public class CertHumanChangeServiceImpl extends BaseServiceImpl<CertHumanChangeMapper, CertHumanChangeEntity> implements ICertHumanChangeService{
    @Autowired
    private ICertHumanService certHumanService;


    @Override
    public CertHumanChangeVO addConvertByApplyId(Long applyId) {
        CertHumanEntity vo = certHumanService.selectById(applyId);
        CertHumanChangeVO changeVO = BeanMapper.map(vo, CertHumanChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setApplyId(changeVO.getId());
        changeVO.setChangeVersion(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(IdWorker.getId());
        return changeVO;
    }
}
