package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.finance.bean.DaypayDetailEntity;
import com.ejianc.business.finance.bean.OccupyDetailEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.OccupyMapper;
import com.ejianc.business.finance.bean.OccupyEntity;
import com.ejianc.business.finance.service.IOccupyService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 出纳资金-占用资金表-主表
 * 
 * @author generator
 * 
 */
@Service("occupyService")
public class OccupyServiceImpl extends BaseServiceImpl<OccupyMapper, OccupyEntity> implements IOccupyService{
    @Autowired
    private IReceiveService receiveService;
    @Override
    public OccupyVO queryData() {
        OccupyEntity occupyEntity = new OccupyEntity();
        occupyEntity.setId(IdWorker.getId());

        //查询收款登记
        List<String> list = new ArrayList<>();
        list.add("合同收款");
        list.add("保证金");
        list.add("项目经理自存款");
        list.add("其他");
        LambdaQueryWrapper<ReceiveEntity> lambdaReceiveWrapper = new LambdaQueryWrapper<>();
        lambdaReceiveWrapper.in(ReceiveEntity::getBillState,1,3);
        lambdaReceiveWrapper.in(ReceiveEntity::getReceiveKindName,list);
        List<ReceiveEntity> receiveEntityList = receiveService.list(lambdaReceiveWrapper);
//        Map<Long, BigDecimal> receiveMap = new HashMap<>();
        Map<String,List<ReceiveEntity>> receiveMap = new HashMap<>();
        List<OccupyDetailEntity> occupyDetailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(receiveEntityList)){

            // 分组后汇总
            // 查询工程计量台账往期值
            receiveMap= receiveEntityList.stream().collect(
                        Collectors.groupingBy(
                                s->s.getProjectId() + "-" + s.getReceiveKindName()
                        ));
            receiveMap.forEach((receiveKey,receiveList)->{
                OccupyDetailEntity occupyDetailEntity = new OccupyDetailEntity();
                List<ReceiveEntity> receiveEntities = receiveList.stream().sorted(Comparator.comparing(ReceiveEntity::getConfirmTime).reversed())
                        .collect(Collectors.toList());
                ReceiveEntity receiveEntity = receiveEntities.stream().findFirst().get();
                occupyDetailEntity.setInDate(receiveEntity.getConfirmTime());
                occupyDetailEntity.setPayTypeId(receiveEntity.getReceiveKind());
                if (receiveEntity.getReceiveKindName().equals("合同收款")){
                    occupyDetailEntity.setPayTypeName("工程款");
                }
                if (receiveEntity.getReceiveKindName().equals("保证金")){
                    occupyDetailEntity.setPayTypeName("保证金");
                }
                if (receiveEntity.getReceiveKindName().equals("项目经理自存款")){
                    occupyDetailEntity.setPayTypeName("代付材料款");
                }
                if (receiveEntity.getReceiveKindName().equals("其他")){
                    occupyDetailEntity.setPayTypeName("其他");
                }
                occupyDetailEntity.setProjectId(receiveEntity.getProjectId());
                occupyDetailEntity.setProjectName(receiveEntity.getProjectName());
                occupyDetailEntity.setOrgId(receiveEntity.getOrgId());
                occupyDetailEntity.setOrgName(receiveEntity.getOrgName());
                BigDecimal receiveMny = receiveEntities.stream().filter(s->s.getReceiveMny() != null).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                occupyDetailEntity.setMoney(receiveMny);
                occupyDetailEntity.setId(IdWorker.getId());
                occupyDetailEntity.setMid(occupyEntity.getId());
                occupyDetailEntityList.add(occupyDetailEntity);
            });
            occupyEntity.setOccupyDetailList(occupyDetailEntityList);
        }
        OccupyVO occupyVO = BeanMapper.map(occupyEntity, OccupyVO.class);
        return occupyVO;
    }
}
