package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标管理-资料上传实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_tender_file")
public class TenderFileEntity extends BaseEntity {

    private static final long serialVersionUID = 897821885105515403L;
    @TableField(value="registration_id")
    private Long registrationId; // 项目报名表Id
    @TableField(value="opportunity_id")
    private Long opportunityId; // 商机登记表Id
    @TableField(value="opportunity_bill_code")
    private Long opportunityBillCode; // 商机登记单据编码
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "employee_name")
    private String employeeName;
    @TableField(value = "employee_id")
    private Long employeeId;
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期

    @TableField(value = "bill_code")
    private String billCode; //单据编码

    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @TableField(exist = false)
    @SubEntity(serviceName = "tenderFileDetailService")
    private List<TenderFileDetailEntity> detailList = new ArrayList<>();

    public List<TenderFileDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TenderFileDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getRegistrationId() {
        return registrationId;
    }

    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    public Long getOpportunityId() {
        return opportunityId;
    }

    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
