package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.tax.bean.PrepaymentPaidEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-预缴完税登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_prepayment_paid")
public class PrepaymentPaidEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 编码
    @TableField(value="cert_id")
    private Long certId; // 外管证
    @TableField(value="cert_name")
    private String certName; // 外管证名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="filling_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillingDate; // 填发日期
    @TableField(value="cross_code")
    private String crossCode; // 跨区域编号
    @TableField(value="billing_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billingDate; // 开票日期
    @TableField(value="billing_mny")
    private BigDecimal billingMny; // 开票金额
    @TableField(value="prepayment_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date prepaymentDate; // 预缴属期
    @TableField(value="tax_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taxDate; // 纳税日期
    @TableField(value="over_tax_code")
    private String overTaxCode; // 完税凭证号码
    @TableField(value="account_id")
    private Long accountId; // 预缴账户
    @TableField(value="account_name")
    private String accountName; // 预缴账户名称
    @TableField(value="prepayment_mny")
    private BigDecimal prepaymentMny; // 预缴小计
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="prepaymentPaidDetailService")
    private List<PrepaymentPaidDetailEntity> prepaymentPaidDetailList = new ArrayList<>(); // 税务管理-预缴完税登记-税务明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCertId() {
        return certId;
    }

    public void setCertId(Long certId) {
        this.certId = certId;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getFillingDate() {
        return fillingDate;
    }

    public void setFillingDate(Date fillingDate) {
        this.fillingDate = fillingDate;
    }
    public String getCrossCode() {
        return crossCode;
    }

    public void setCrossCode(String crossCode) {
        this.crossCode = crossCode;
    }
    public Date getBillingDate() {
        return billingDate;
    }

    public void setBillingDate(Date billingDate) {
        this.billingDate = billingDate;
    }
    public BigDecimal getBillingMny() {
        return billingMny;
    }

    public void setBillingMny(BigDecimal billingMny) {
        this.billingMny = billingMny;
    }
    public Date getPrepaymentDate() {
        return prepaymentDate;
    }

    public void setPrepaymentDate(Date prepaymentDate) {
        this.prepaymentDate = prepaymentDate;
    }
    public Date getTaxDate() {
        return taxDate;
    }

    public void setTaxDate(Date taxDate) {
        this.taxDate = taxDate;
    }
    public String getOverTaxCode() {
        return overTaxCode;
    }

    public void setOverTaxCode(String overTaxCode) {
        this.overTaxCode = overTaxCode;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public BigDecimal getPrepaymentMny() {
        return prepaymentMny;
    }

    public void setPrepaymentMny(BigDecimal prepaymentMny) {
        this.prepaymentMny = prepaymentMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<PrepaymentPaidDetailEntity> getPrepaymentPaidDetailList() {
        return prepaymentPaidDetailList;
    }

    public void setPrepaymentPaidDetailList(List<PrepaymentPaidDetailEntity> prepaymentPaidDetailList) {
        this.prepaymentPaidDetailList = prepaymentPaidDetailList;
    }
}
