/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.invest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.invest.bean.IncomeDetailEntity;
import com.ejianc.business.invest.bean.IncomeEntity;
import com.ejianc.business.invest.service.IIncomeDetailService;
import com.ejianc.business.invest.service.IIncomeService;
import com.ejianc.business.invest.vo.IncomeDetailVO;
import com.ejianc.business.invest.vo.IncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"income"})
public class IncomeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BFYJ_XMTZ_TZSY";
    @Autowired
    private IIncomeService service;
    @Autowired
    private IIncomeDetailService incomeDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IncomeVO> saveOrUpdate(@RequestBody IncomeVO saveOrUpdateVO) {
        IncomeEntity entity = (IncomeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, IncomeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            List incomeEntityList = this.service.list((Wrapper)new QueryWrapper().eq((Object)"month", (Object)saveOrUpdateVO.getMonth()));
            if (CollectionUtils.isNotEmpty((Collection)incomeEntityList) && incomeEntityList.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u6708\u4efd\u5355\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u5207\u6362\u6708\u4efd\uff01");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        IncomeVO vo = (IncomeVO)BeanMapper.map((Object)((Object)entity), IncomeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IncomeVO> queryDetail(Long id) {
        IncomeEntity entity = (IncomeEntity)((Object)this.service.selectById(id));
        IncomeVO vo = (IncomeVO)BeanMapper.map((Object)((Object)entity), IncomeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<IncomeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (IncomeVO incomeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<IncomeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), IncomeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, IncomeVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("Income-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refIncomeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<IncomeVO>> refIncomeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), IncomeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryIncomeReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryIncomeReport(@RequestBody QueryParam param) {
        JSONObject page = new JSONObject();
        List<Object> incomeYearVOList = new ArrayList();
        String year = "";
        String searchText = param.getSearchText();
        int total = 0;
        if (null != param.getParams().get("year")) {
            year = String.valueOf(((Parameter)param.getParams().get("year")).getValue()).substring(0, 4);
            param.getParams().remove("year");
            incomeYearVOList = this.service.queryIncomeReport(year, searchText);
            total = incomeYearVOList.size();
            if (CollectionUtils.isNotEmpty(incomeYearVOList) && incomeYearVOList.size() > 0) {
                incomeYearVOList = incomeYearVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList());
            }
        }
        page.put("records", incomeYearVOList);
        page.put("total", (Object)total);
        page.put("current", (Object)param.getPageIndex());
        page.put("size", (Object)param.getPageSize());
        page.put("pages", (Object)(Math.ceil(incomeYearVOList.size() / param.getPageSize()) + 1.0));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<Object> incomeYearVOList = new ArrayList();
        String year = "";
        String searchText = param.getSearchText();
        if (null != param.getParams().get("year")) {
            year = String.valueOf(((Parameter)param.getParams().get("year")).getValue()).substring(0, 4);
            param.getParams().remove("year");
            incomeYearVOList = this.service.queryIncomeReport(year, searchText);
            if (CollectionUtils.isNotEmpty(incomeYearVOList) && incomeYearVOList.size() > 0) {
                incomeYearVOList = incomeYearVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", incomeYearVOList);
        ExcelExport.getInstance().export("IncomeYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryDataByMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<IncomeDetailVO>> queryDataByMonth(Long id, String month) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"month", (Object)(month + "-01"));
        if (null != id) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entityList = this.service.list((Wrapper)queryWrapper))) && entityList.size() > 0) {
            throw new BusinessException("\u5f53\u524d\u6708\u4efd\u5df2\u6709\u5bf9\u5e94\u5355\u636e\uff01");
        }
        List detailVOList = new ArrayList();
        List list = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"month", (Object)LocalDate.parse(month + "-01").minusMonths(1L)));
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            IncomeEntity incomeEntity = (IncomeEntity)((Object)this.service.selectById(((IncomeEntity)((Object)list.get(0))).getId()));
            for (IncomeDetailEntity incomeDetailEntity : incomeEntity.getIncomeDetailList()) {
                incomeDetailEntity.setId(IdWorker.getId());
            }
            detailVOList = BeanMapper.mapList(incomeEntity.getIncomeDetailList(), IncomeDetailVO.class);
        }
        return CommonResponse.success((String)"\u6839\u636e\u6708\u4efd\u67e5\u8be2\u4e0a\u6708\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01", detailVOList);
    }
}

