package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.vo.InstoreDetailVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.InstoreDetailMapper;
import com.ejianc.business.oa.bean.InstoreDetailEntity;
import com.ejianc.business.oa.service.IInstoreDetailService;

import java.util.List;

/**
 * 人力行政-资产入库单子表
 * 
 * @author generator
 * 
 */
@Service("instoreDetailService")
public class InstoreDetailServiceImpl extends BaseServiceImpl<InstoreDetailMapper, InstoreDetailEntity> implements IInstoreDetailService{

    @Override
    public IPage<InstoreDetailVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        IPage<InstoreDetailVO> page = new Page<>();
        page.setCurrent(pageNum);
        page.setPages(pageSize);
        page.setSize(pageSize);
        String materialTypeName="";
        String materialName="";
        String materialSpec="";
        String materialUnit="";
        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            if(search.get("materialCategoryName")!=null){
                materialTypeName = search.get("materialCategoryName").toString();
            }
            if(search.get("materialName")!=null){
                materialName = search.get("materialName").toString();
            }
            if(search.get("materialSpec")!=null){
                materialSpec = search.get("materialSpec").toString();
            }
            if(search.get("materialUnit")!=null){
                materialUnit = search.get("materialUnit").toString();
            }
        }

        Long count = baseMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName,materialName,materialSpec,materialUnit);
        page.setTotal(count);
        List<InstoreDetailVO> records =
                baseMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName,materialName,materialSpec,materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreDetailVO> queryStoreData(Page<InstoreDetailEntity> page, QueryWrapper<InstoreDetailVO> queryWrapper) {
        return baseMapper.queryStoreData(page, queryWrapper);
    }
}
