/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payContract"})
public class PayContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayContractService service;
    @Autowired
    private IPayRecordService payRecordService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO saveOrUpdateVO) {
        PayContractEntity entity = (PayContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayContractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam;
            CommonResponse billCode;
            String bill_code = "RENT_PAY_CONTRACT_P";
            if ("2".equals(entity.getProjectType())) {
                bill_code = "RENT_PAY_CONTRACT_C";
            }
            if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)bill_code, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setUnPayMny(entity.getApplyMny());
        this.service.saveOrUpdate((Object)entity, false);
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)entity), PayContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
        PayContractEntity entity = (PayContractEntity)((Object)this.service.selectById(id));
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)entity), PayContractVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayRecordEntity::getPayapplyId, (Object)id);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List list = this.payRecordService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setPayRecordList(BeanMapper.mapList((Iterable)list, PayRecordVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayContractVO payContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPendingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(x -> (QueryWrapper)x.last("IFNULL(apply_mny,0)>IFNULL(pay_mny,0)"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> pageData = this.service.pageList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelPendingExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelPendingExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(x -> (QueryWrapper)x.last("IFNULL(apply_mny,0)>IFNULL(pay_mny,0)"));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> resList = this.service.pageList(page, wrapper);
        if (CollectionUtils.isNotEmpty(resList)) {
            resList.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                if (1 == e.getContractType()) {
                    e.setContractTypeName("\u52b3\u52a1\u8d39\u7528");
                } else if (2 == e.getContractType()) {
                    e.setContractTypeName("\u673a\u68b0\u8d39\u7528");
                } else if (3 == e.getContractType()) {
                    e.setContractTypeName("\u6750\u6599\u8d39\u7528");
                } else {
                    e.setContractTypeName("\u5176\u4ed6\u8d39\u7528");
                }
            });
        }
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryAllList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> pageData = this.service.pageList(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", pageData);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelAllExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelAllExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> resList = this.service.pageList(page, wrapper);
        if (CollectionUtils.isNotEmpty(resList)) {
            resList.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                if (1 == e.getContractType()) {
                    e.setContractTypeName("\u52b3\u52a1\u8d39\u7528");
                } else if (2 == e.getContractType()) {
                    e.setContractTypeName("\u673a\u68b0\u8d39\u7528");
                } else if (3 == e.getContractType()) {
                    e.setContractTypeName("\u6750\u6599\u8d39\u7528");
                } else {
                    e.setContractTypeName("\u5176\u4ed6\u8d39\u7528");
                }
            });
        }
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, PayContractVO.class);
            resList.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
                if (1 == e.getContractType()) {
                    e.setContractTypeName("\u52b3\u52a1\u8d39\u7528");
                } else if (2 == e.getContractType()) {
                    e.setContractTypeName("\u673a\u68b0\u8d39\u7528");
                } else if (3 == e.getContractType()) {
                    e.setContractTypeName("\u6750\u6599\u8d39\u7528");
                } else {
                    e.setContractTypeName("\u5176\u4ed6\u8d39\u7528");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPayContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayContractVO>> refPayContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

