package com.ejianc.business.bid.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.PlatformEntity;
import com.ejianc.business.bid.vo.BidOpenResultVO;
import com.ejianc.business.bid.vo.CompanyPerformanceVO;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/11/13 19:58
 */
@RestController
@RequestMapping(value = "companyPerformance")
public class CompanyPerformanceController {

    @Autowired
    private IProjectRegisterService projectRegisterService;

    @PostMapping(value = "/queryList")
    public CommonResponse<IPage<CompanyPerformanceVO>> queryList(@RequestBody QueryParam queryParam) {

        Map<String, Object> params = new HashMap<>();
        for(String key : queryParam.getParams().keySet()) {
            if("bidMny".equals(key)) {
                if("between".equals(queryParam.getParams().get(key).getType())) {
                    params.put("bidMnyS", queryParam.getParams().get(key).getValue().toString().split(",")[0]);
                    params.put("bidMnyL", queryParam.getParams().get(key).getValue().toString().split(",")[1]);
                } else if("ge".equals(queryParam.getParams().get(key).getType())) {
                    params.put("bidMnyS", queryParam.getParams().get(key).getValue());
                } else {
                    params.put("bidMnyL", queryParam.getParams().get(key).getValue());
                }
            } else {
                params.put(key, queryParam.getParams().get(key).getValue());
            }
        }
        params.put("tenant_id", InvocationInfoProxy.getTenantid());

        IPage<CompanyPerformanceVO> pageData = null;
        int count = projectRegisterService.countPerformance(params);
        if(count == 0) {
            pageData = new Page<>(queryParam.getPageIndex(),
                    queryParam.getPageSize(), 0);
            pageData.setRecords(new ArrayList<>());
            return CommonResponse.success(pageData);
        }

        pageData = new Page<>(queryParam.getPageIndex(),
                queryParam.getPageSize(), count);

        params.put("pageSize", queryParam.getPageSize());
        params.put("pageIndex", (queryParam.getPageIndex() < 1 ? 0 : (queryParam.getPageIndex() -  1)) * queryParam.getPageSize());

        List<CompanyPerformanceVO> list = projectRegisterService.pagePerformance(params);

        pageData.setRecords(list);

        return CommonResponse.success(pageData);
    }


    /**
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {

        Map<String, Object> params = new HashMap<>();
        for(String key : queryParam.getParams().keySet()) {
            if("bidMny".equals(key)) {
                if("between".equals(queryParam.getParams().get(key).getType())) {
                    params.put("bidMnyS", queryParam.getParams().get(key).getValue().toString().split(",")[0]);
                    params.put("bidMnyL", queryParam.getParams().get(key).getValue().toString().split(",")[1]);
                } else if("ge".equals(queryParam.getParams().get(key).getType())) {
                    params.put("bidMnyS", queryParam.getParams().get(key).getValue());
                } else {
                    params.put("bidMnyL", queryParam.getParams().get(key).getValue());
                }
            } else {
                params.put(key, queryParam.getParams().get(key).getValue());
            }
        }
        params.put("tenant_id", InvocationInfoProxy.getTenantid());

        List<CompanyPerformanceVO> list = projectRegisterService.pagePerformance(params);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("CompanyPerformance-export.xlsx", beans, response);
    }


}
