package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.vo.PayContractVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 出纳资金-合同付款申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payContract")
public class PayContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPayContractService service;

    @Autowired
    private IPayRecordService payRecordService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO saveOrUpdateVO) {
    	PayContractEntity entity = BeanMapper.map(saveOrUpdateVO, PayContractEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String bill_code = "RENT_PAY_CONTRACT_P";
    	    if("2".equals(entity.getProjectType())){
                bill_code = "RENT_PAY_CONTRACT_C";
            }
            BillCodeParam billCodeParam = BillCodeParam.build(bill_code,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setUnPayMny(entity.getApplyMny());
    	service.saveOrUpdate(entity, false);
    	PayContractVO vo = BeanMapper.map(entity, PayContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
    	PayContractEntity entity = service.selectById(id);
    	PayContractVO vo = BeanMapper.map(entity, PayContractVO.class);

        LambdaQueryWrapper<PayRecordEntity> lambda = Wrappers.<PayRecordEntity>lambdaQuery();
        lambda.eq(PayRecordEntity::getPayapplyId, id);
        lambda.orderByDesc(PayRecordEntity::getCreateTime);
        List<PayRecordEntity> list = payRecordService.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setPayRecordList(BeanMapper.mapList(list,PayRecordVO.class));
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PayContractEntity> page = service.queryPage(param,false);
        IPage<PayContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询待处理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPendingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        QueryWrapper<PayContractVO> wrapper = changeToQueryWrapper(param);
        // 未支付或者支付金额小于申请金额为待处理
        wrapper.and(x -> x.last("IFNULL(apply_mny,0)>IFNULL(pay_mny,0)"));
        Page<PayContractEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> pageData = service.pageList(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", pageData);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelPendingExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelPendingExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper<PayContractVO> wrapper = changeToQueryWrapper(param);
        // 未支付或者支付金额小于申请金额为待处理
        wrapper.and(x -> x.last("IFNULL(apply_mny,0)>IFNULL(pay_mny,0)"));
        Page<PayContractEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> resList = service.pageList(page,wrapper);

//        List<PayContractEntity> list = service.queryList(param);
        if(CollectionUtils.isNotEmpty(resList)){
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                // 合同类型：1-劳务费用,2-机械费用,3-材料费用,4-其他费用
                if(1==e.getContractType()){
                    e.setContractTypeName("劳务费用");
                }else if(2==e.getContractType()){
                    e.setContractTypeName("机械费用");
                }else if(3==e.getContractType()){
                    e.setContractTypeName("材料费用");
                }else{
                    e.setContractTypeName("其他费用");
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }


    /**
     * @Description queryList 查询待处理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryAllList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<PayContractEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> pageData = service.pageList(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", pageData);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！",res);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelAllExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelAllExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper<PayContractVO> wrapper = changeToQueryWrapper(param);
        Page<PayContractEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayContractVO> resList = service.pageList(page,wrapper);
        if(CollectionUtils.isNotEmpty(resList)){
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                // 合同类型：1-劳务费用,2-机械费用,3-材料费用,4-其他费用
                if(1==e.getContractType()){
                    e.setContractTypeName("劳务费用");
                }else if(2==e.getContractType()){
                    e.setContractTypeName("机械费用");
                }else if(3==e.getContractType()){
                    e.setContractTypeName("材料费用");
                }else{
                    e.setContractTypeName("其他费用");
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayContractEntity> list = service.queryList(param);
        List<PayContractVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            resList = BeanMapper.mapList(list,PayContractVO.class);
            resList.forEach(e->{
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                // 合同类型：1-劳务费用,2-机械费用,3-材料费用,4-其他费用
                if(1==e.getContractType()){
                    e.setContractTypeName("劳务费用");
                }else if(2==e.getContractType()){
                    e.setContractTypeName("机械费用");
                }else if(3==e.getContractType()){
                    e.setContractTypeName("材料费用");
                }else{
                    e.setContractTypeName("其他费用");
                }
            });
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Finance-PayContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPayContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayContractVO>> refPayContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayContractEntity> page = service.queryPage(param,false);
        IPage<PayContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
