package com.ejianc.business.bid.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.MonthFeeCommissionEntity;
import com.ejianc.business.bid.service.IMonthFeeCommissionService;
import com.ejianc.business.bid.vo.MonthFeeCommissionVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 公司月度费用提成报表生产
 *
 * @author CJ
 * @Description:
 * @date 2024/11/11 19:53
 */
@RestController
@RequestMapping(value = "monthFeeCommission")
public class MonthFeeCommissionController {


    @Autowired
    private IMonthFeeCommissionService service;

    @GetMapping(value = "autoGenerate")
    public CommonResponse<String> generateMothFeeCommission() {
        service.generateMothFeeCommission();

        return CommonResponse.success("月度费用提成报表单据生成完成！");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<MonthFeeCommissionVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("deptName");
        fuzzyFields.add("postName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        IPage<MonthFeeCommissionEntity> page = service.queryPage(param,false);
        IPage<MonthFeeCommissionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthFeeCommissionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("deptName");
        fuzzyFields.add("postName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<MonthFeeCommissionEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list, MonthFeeCommissionVO.class));
        ExcelExport.getInstance().export("MonFeeCommission-export.xlsx", beans, response);
    }

}
