package com.ejianc.business.project.controller;

import java.io.Serializable;

import com.ejianc.business.project.OnSitePostVO;
import com.ejianc.business.project.bean.OnSitePostEntity;
import com.ejianc.business.project.service.IOnSitePostService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 项目基本信息管理-驻场岗位档案
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("onSitePost")
public class OnSitePostController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID_ON_SITE_POST";

    @Autowired
    private IOnSitePostService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<OnSitePostVO> saveOrUpdate(@RequestBody OnSitePostVO saveOrUpdateVO) {
    	OnSitePostEntity entity = null;
    	if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            entity = BeanMapper.map(saveOrUpdateVO, OnSitePostEntity.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        } else {
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setDailyMny(saveOrUpdateVO.getDailyMny());
            entity.setEnabled(saveOrUpdateVO.getEnabled());
        }
    	service.saveOrUpdate(entity, false);
    	OnSitePostVO vo = BeanMapper.map(entity, OnSitePostVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @PostMapping(value = "/changeEnabledStatus")
    public CommonResponse<String> changeEnabledStatus(@RequestBody OnSitePostVO onSitePostVO) {
        OnSitePostEntity entity = service.selectById(onSitePostVO.getId());
        entity.setEnabled(onSitePostVO.getEnabled());
        service.saveOrUpdate(entity, false);

        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<OnSitePostVO> queryDetail(Long id) {
    	OnSitePostEntity entity = service.selectById(id);
    	OnSitePostVO vo = BeanMapper.map(entity, OnSitePostVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<OnSitePostVO> vos) {
        service.removeByIds(vos.stream().map(OnSitePostVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<OnSitePostVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<OnSitePostEntity> page = service.queryPage(param,false);
        IPage<OnSitePostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OnSitePostVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<OnSitePostEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OnSitePost-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refOnSitePostData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OnSitePostVO>> refOnSitePostData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OnSitePostEntity> page = service.queryPage(param,false);
        IPage<OnSitePostVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OnSitePostVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
