/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.CheckItemReformState;
import com.ejianc.business.scene.utils.ModifyState;
import com.ejianc.business.scene.utils.NoticeEnum;
import com.ejianc.business.scene.utils.OperationState;
import com.ejianc.business.scene.utils.ReformState;
import com.ejianc.business.scene.utils.ReviewState;
import com.ejianc.business.scene.utils.SubmitState;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"review"})
public class ReviewController {
    @Autowired
    private ICheckBfyjService service;
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private CheckMessageService checkMessageService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CheckBfyjVO> queryDetail(@RequestParam Long id) {
        CheckBfyjEntity entity = (CheckBfyjEntity)((Object)this.service.selectById(id));
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails, CheckDetailBfyjVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            CheckDetailBfyjVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        CheckBfyjVO vo = (CheckBfyjVO)BeanMapper.map((Object)((Object)entity), CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reform_status", new Parameter("in", Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("review_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getUserId().toString()));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("review_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getEmployeeId().toString()));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        param.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CheckBfyjVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/submitReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckBfyjVO> submitReviewNews(@RequestBody CheckBfyjVO param) {
        boolean update;
        int size;
        CheckBfyjEntity entity = (CheckBfyjEntity)((Object)BeanMapper.map((Object)param, CheckBfyjEntity.class));
        CheckBfyjVO vo = (CheckBfyjVO)BeanMapper.map((Object)((Object)entity), CheckBfyjVO.class);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List reviewResults = sceneCheckDetails.stream().map(CheckDetailBfyjEntity::getReviewResult).collect(Collectors.toList());
            ArrayList list = new ArrayList();
            List<CheckDetailBfyjEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                updateWrapper.set(CheckBfyjEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(Integer.valueOf(sceneCheckDetailList.size()));
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId != null) {
                    String[] reformDutyIds = reformDutyId.split(",");
                    this.checkMessageService.sendMsg(vo, reformDutyIds, NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            if ((size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size()) == sceneCheckDetails.size()) {
                updateWrapper.set(CheckBfyjEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId != null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(Integer.valueOf(0));
                    this.checkMessageService.sendMsg(vo, notifRelevantIds, NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform() == Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    CheckRecordBfyjEntity sceneCheckRecord = new CheckRecordBfyjEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                this.sceneCheckRecordService.saveBatch(list, list.size());
            }
            sceneCheckDetails.forEach(sceneCheckitem -> {
                if (ReviewState.REVIEW_FAILED_STATE.getCode().equals(sceneCheckitem.getReviewResult())) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("pid", new Parameter("eq", (Object)sceneCheckitem.getId()));
                    queryParam.getOrderMap().put("createTime", "desc");
                    queryParam.getParams().put("operation_type", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
                    List sceneCheckRecords = this.sceneCheckRecordService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty((Collection)sceneCheckRecords)) {
                        System.out.println(sceneCheckRecords);
                        CheckRecordBfyjEntity CheckRecordBfyjEntity2 = (CheckRecordBfyjEntity)((Object)((Object)sceneCheckRecords.get(0)));
                        if (CheckRecordBfyjEntity2.getImgIds() != null) {
                            List<String> imgids = Arrays.asList(CheckRecordBfyjEntity2.getImgIds().split(","));
                            ArrayList attachIds = new ArrayList();
                            imgids.forEach(item -> attachIds.add(Long.parseLong(item)));
                            this.iAttachmentApi.updateAttachRef(CheckRecordBfyjEntity2.getId(), attachIds);
                        }
                    }
                }
            });
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper updateReviewMsgWrapper = new LambdaUpdateWrapper();
                updateReviewMsgWrapper.eq(BaseEntity::getId, (Object)item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty((String)item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(CheckDetailBfyjEntity::getReviewMsg, (Object)(item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe));
                Integer reviewResult = item.getReviewResult();
                this.sceneCheckDetailService.update((Wrapper)updateReviewMsgWrapper);
            });
        }
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper isModifyWrapper = new LambdaUpdateWrapper();
                isModifyWrapper.eq(BaseEntity::getId, (Object)item.getId());
                isModifyWrapper.set(CheckDetailBfyjEntity::getIsModify, (Object)Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                this.sceneCheckDetailService.update((Wrapper)isModifyWrapper);
            }
        });
        System.out.println("=============");
        System.out.println(sceneCheckDetails);
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper sceneUpdateWrapper = new LambdaUpdateWrapper();
                sceneUpdateWrapper.eq(BaseEntity::getId, (Object)item.getId());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getReviewDate, (Object)new Date());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getTaskState, (Object)CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getReviewResult, (Object)ReviewState.REVIEW_FAILED_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)sceneUpdateWrapper);
            }
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper successWrapper = new LambdaUpdateWrapper();
                successWrapper.eq(BaseEntity::getId, (Object)item.getId());
                successWrapper.set(CheckDetailBfyjEntity::getTaskState, (Object)CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());
                successWrapper.set(CheckDetailBfyjEntity::getReviewResult, (Object)ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(CheckDetailBfyjEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate() == null) {
                    successWrapper.set(CheckDetailBfyjEntity::getReviewDate, (Object)new Date());
                }
                this.sceneCheckDetailService.update((Wrapper)successWrapper);
            }
        });
        Map<Integer, List<CheckDetailBfyjEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(CheckDetailBfyjEntity::getReviewResult));
        updateWrapper.set(CheckBfyjEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFinishedWrapper = new LambdaUpdateWrapper();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(CheckBfyjEntity::getReviewPass, (Object)reviewFinished);
                revieweFinishedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                size = this.service.update((Wrapper)revieweFinishedWrapper) ? 1 : 0;
            }
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFailedWrapper = new LambdaUpdateWrapper();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size2 = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(CheckBfyjEntity::getReviewedNum, (Object)size2);
                revieweFailedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                boolean bl = this.service.update((Wrapper)revieweFailedWrapper);
            }
        }
        if (update = this.service.update((Wrapper)updateWrapper)) {
            Long id = entity.getId();
            CheckBfyjEntity checkenEntity = (CheckBfyjEntity)((Object)this.service.selectById(id));
            CheckBfyjVO CheckBfyjVO2 = (CheckBfyjVO)BeanMapper.map((Object)((Object)checkenEntity), CheckBfyjVO.class);
            return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)CheckBfyjVO2);
        }
        return CommonResponse.error((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/saveReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CheckBfyjVO> saveReviewNews(@RequestBody CheckBfyjVO param) {
        CheckBfyjEntity entity = (CheckBfyjEntity)((Object)BeanMapper.map((Object)param, CheckBfyjEntity.class));
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                String userName = this.sessionManager.getUserContext().getUserName();
                updateWrapper.set(CheckDetailBfyjEntity::getActualReviewer, (Object)userName);
                updateWrapper.eq(BaseEntity::getId, (Object)sceneCheckDetail.getId());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewResult, (Object)sceneCheckDetail.getReviewResult());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewDescribe, (Object)sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewImgIds, (Object)sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewImgUrl, (Object)sceneCheckDetail.getReviewImgUrl());
                this.sceneCheckDetailService.update((Wrapper)updateWrapper);
            });
        }
        Long id = entity.getId();
        CheckBfyjEntity sceneCheck = (CheckBfyjEntity)((Object)this.service.selectById(id));
        CheckBfyjVO vo = (CheckBfyjVO)BeanMapper.map((Object)((Object)sceneCheck), CheckBfyjVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

