package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.ProjectPersonAffirmMapper;
import com.ejianc.business.bid.bean.ProjectPersonAffirmEntity;
import com.ejianc.business.bid.service.IProjectPersonAffirmService;

import java.util.List;

/**
 * 投标管理-确认项目经理及技术负责人
 * 
 * @author generator
 * 
 */
@Service("projectPersonAffirmService")
public class ProjectPersonAffirmServiceImpl extends BaseServiceImpl<ProjectPersonAffirmMapper, ProjectPersonAffirmEntity> implements IProjectPersonAffirmService{

    @Override
    public List<ProjectPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<ProjectPersonAffirmEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
