/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payContract")
public class PayContractBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayContractService service;
    @Autowired
    private IPayRecordService recordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity;
        if (null != billId) {
            CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de!");
        }
        if (!this.validateApproveTime(entity = (PayContractEntity)((Object)this.service.selectById(billId)))) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u975e\u6700\u65b0\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        if (!this.validateEffective(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5728\u672c\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity applyEntity = (PayContractEntity)((Object)this.service.selectById(billId));
        applyEntity.setPayMny(BigDecimal.ZERO);
        applyEntity.setUnPayMny(ComputeUtil.safeSub((BigDecimal)applyEntity.getApplyMny(), (BigDecimal)applyEntity.getPayMny()));
        applyEntity.setConfirmTime(null);
        this.service.updateById((Object)applyEntity);
        this.recordService.remove((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        return CommonResponse.success();
    }

    private boolean validateEffective(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.ne((Object)"bill_state", (Object)1);
        wrapper.ne((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }

    private boolean validateApproveTime(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        wrapper.gt((Object)"apply_date", (Object)entity.getApplyDate());
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

