package com.ejianc.business.bid.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 投标管理-CA锁登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bid_ca_lock")
public class CALockEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode;
    @TableField(value="belong_area")
    private String belongArea; // CA锁所属区域
    @TableField(value="belong_web_addr")
    private String belongWebAddr; // 所属区域网址
    @TableField(value="employee_id")
    private Long employeeId; // 编制人ID
    @TableField(value="employee_name")
    private String employeeName; // 编制人
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="cALockDetailService")
    private List<CALockDetailEntity> detailList = new ArrayList<>(); // 投标管理-CA锁登记子表

    public List<CALockDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CALockDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBelongArea() {
        return belongArea;
    }

    public void setBelongArea(String belongArea) {
        this.belongArea = belongArea;
    }
    public String getBelongWebAddr() {
        return belongWebAddr;
    }

    public void setBelongWebAddr(String belongWebAddr) {
        this.belongWebAddr = belongWebAddr;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
}
