package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.asset.vo.ProjectApprovalVO;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.DaypayVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.DaypayMapper;

import java.math.BigDecimal;
import java.text.CollationElementIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 出纳资金-出纳日报表-主表
 * 
 * @author generator
 * 
 */
@Service("daypayService")
public class DaypayServiceImpl extends BaseServiceImpl<DaypayMapper, DaypayEntity> implements IDaypayService{

    @Autowired
    private IAccountRegisterService accountRegisterService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IInternalExchangeService internalExchangeService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IDeductionService deductionService;
    @Autowired
    private IDaypayDetailService daypayDetailService;

    @Override
    public DaypayVO queryData() {
        //查询所有账户
        LambdaQueryWrapper<AccountRegisterEntity> lambdaAccountWrapper = new LambdaQueryWrapper<>();
        lambdaAccountWrapper.in(AccountRegisterEntity::getBillState,1,3);
        List<AccountRegisterEntity> accountRegisterEntities = accountRegisterService.list(lambdaAccountWrapper);

        //查询收款登记
        LambdaQueryWrapper<ReceiveEntity> lambdaReceiveWrapper = new LambdaQueryWrapper<>();
        lambdaReceiveWrapper.in(ReceiveEntity::getBillState,1,3);
        List<ReceiveEntity> receiveEntityList = receiveService.list(lambdaReceiveWrapper);
        Map<Long, BigDecimal> receiveMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(receiveEntityList)){
            // 分组后汇总
            receiveMap = receiveEntityList.stream().filter(s->s.getAccountId() != null).collect(Collectors.groupingBy(ReceiveEntity::getAccountId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReceiveMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //查询往来款
        LambdaQueryWrapper<InternalExchangeEntity> lambdaExchangeWrapper = new LambdaQueryWrapper<>();
        lambdaExchangeWrapper.in(InternalExchangeEntity::getBillState,1,3);
        List<InternalExchangeEntity> exchangeEntityList = internalExchangeService.list(lambdaExchangeWrapper);
        Map<Long, BigDecimal> exchangeInMap = new HashMap<>();
        Map<Long, BigDecimal> exchangeOutMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(exchangeEntityList)){
            // 分组后汇总
            exchangeInMap = exchangeEntityList.stream().filter(s->s.getInAccountRegisterId() != null).collect(Collectors.groupingBy(InternalExchangeEntity::getInAccountRegisterId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            exchangeOutMap = exchangeEntityList.stream().filter(s->s.getAccountRegisterId() != null).collect(Collectors.groupingBy(InternalExchangeEntity::getAccountRegisterId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //查询支出管理--支出记录
        LambdaQueryWrapper<PayRecordEntity> lambdaRecord = Wrappers.<PayRecordEntity>lambdaQuery();
        List<PayRecordEntity> payRecordEntityList = payRecordService.list(lambdaRecord);
        Map<Long, BigDecimal> payRecordMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(payRecordEntityList)){
            // 分组后汇总
            payRecordMap = payRecordEntityList.stream().filter(s->s.getAccountRegisterId() != null).collect(Collectors.groupingBy(PayRecordEntity::getAccountRegisterId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getThisPayMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //查询扣款单
        LambdaQueryWrapper<DeductionEntity> lambdaDeduction = Wrappers.<DeductionEntity>lambdaQuery();
        List<DeductionEntity> deductionEntityList = deductionService.list(lambdaDeduction);
        Map<Long, BigDecimal> deductionMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(deductionEntityList)){
            // 分组后汇总
            deductionMap = deductionEntityList.stream().filter(s->s.getAccountRegisterId() != null).collect(Collectors.groupingBy(DeductionEntity::getAccountRegisterId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        //查询往期值
        LambdaQueryWrapper<DaypayEntity> lambdaLastWrapper = new LambdaQueryWrapper<>();
        lambdaLastWrapper.in(DaypayEntity::getBillState,1,3);
        lambdaLastWrapper.orderByDesc(DaypayEntity::getDate);
        List<DaypayEntity> daypayEntityList = super.list(lambdaLastWrapper);
        Map<Long, DaypayDetailEntity> daypayDetailLastMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(daypayEntityList)){
            DaypayEntity daypayEntity = daypayEntityList.stream().findFirst().get();
            //查询往期值
            LambdaQueryWrapper<DaypayDetailEntity> lambdaLastDetailWrapper = new LambdaQueryWrapper<>();
            lambdaLastDetailWrapper.in(DaypayDetailEntity::getMid,daypayEntity.getId());
            List<DaypayDetailEntity> daypayDetailEntities = daypayDetailService.list(lambdaLastDetailWrapper);
            if (CollectionUtils.isNotEmpty(daypayDetailEntities)){
                daypayDetailLastMap = daypayDetailEntities.stream().filter(s->s.getBankId() != null).collect(Collectors.toMap(DaypayDetailEntity::getBankId, Function.identity()));
            }
        }

        //组装数据
        List<DaypayDetailEntity> daypayDetailEntities = new ArrayList<>();
        DaypayEntity daypayEntity = new DaypayEntity();
        daypayEntity.setId(IdWorker.getId());
        if (CollectionUtils.isNotEmpty(accountRegisterEntities)){
            for (AccountRegisterEntity accountRegisterEntity : accountRegisterEntities){
                Long accountId = accountRegisterEntity.getId();
                DaypayDetailEntity daypayDetailEntity = new DaypayDetailEntity();
                //期初
                BigDecimal lastIncomeMoney = BigDecimal.ZERO;
                BigDecimal lastPayMoney = BigDecimal.ZERO;
                if (daypayDetailLastMap.containsKey(accountId)){
                    DaypayDetailEntity lastDaypayDetailEntity = daypayDetailLastMap.get(accountId);
                    daypayDetailEntity.setStartMoney(lastDaypayDetailEntity.getEndMoney());
                    lastPayMoney = lastDaypayDetailEntity.getPayMoney();
                }

                //收入
                BigDecimal receiveMoney = BigDecimal.ZERO;
                if (receiveMap.containsKey(accountId)){
                    receiveMoney = receiveMap.get(accountId);
                }
                //往来款
                BigDecimal exchangeInMoney = BigDecimal.ZERO;
                if (exchangeInMap.containsKey(accountId)){
                    exchangeInMoney = exchangeInMap.get(accountId);
                }
                //本期收入
                daypayDetailEntity.setIncomeMoney(ComputeUtil.safeSub(ComputeUtil.safeAdd(receiveMoney,exchangeInMoney),lastIncomeMoney));

                //支出
                //往来款
                BigDecimal exchangeOutMoney = BigDecimal.ZERO;
                if (exchangeOutMap.containsKey(accountId)){
                    exchangeOutMoney = exchangeOutMap.get(accountId);
                }

                //支出
                BigDecimal recordOutMoney = BigDecimal.ZERO;
                if (payRecordMap.containsKey(accountId)){
                    recordOutMoney = payRecordMap.get(accountId);
                }
                //扣款
                BigDecimal deductionMoney = BigDecimal.ZERO;
                if (deductionMap.containsKey(accountId)){
                    deductionMoney = deductionMap.get(accountId);
                }

                //本期支出
                BigDecimal outMny = ComputeUtil.safeAdd(ComputeUtil.safeAdd(exchangeOutMoney, recordOutMoney), deductionMoney);
                daypayDetailEntity.setPayMoney(ComputeUtil.safeSub(outMny,lastPayMoney));
                //结余
                BigDecimal endMoney = ComputeUtil.safeSub(ComputeUtil.safeAdd(daypayDetailEntity.getStartMoney(), daypayDetailEntity.getIncomeMoney()), daypayDetailEntity.getPayMoney());
                daypayDetailEntity.setEndMoney(endMoney);
                daypayDetailEntity.setId(IdWorker.getId());
                daypayDetailEntity.setMid(daypayEntity.getId());
                daypayDetailEntities.add(daypayDetailEntity);
            }
            daypayEntity.setDaypayDetailList(daypayDetailEntities);

            //汇总表头数据
            BigDecimal startMoney = daypayDetailEntities.stream().filter(s->s.getStartMoney() != null).map(DaypayDetailEntity::getStartMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal endMoney = daypayDetailEntities.stream().filter(s->s.getEndMoney() != null).map(DaypayDetailEntity::getEndMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            daypayEntity.setStartMny(startMoney);
            daypayEntity.setEndMny(endMoney);
        }
        DaypayVO daypayVO = BeanMapper.map(daypayEntity, DaypayVO.class);

        return daypayVO;
    }
}
