package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Service("payContract") 
public class PayContractBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPayContractService service;
	@Autowired
	private IPayRecordService recordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		if (null != billId){
			return CommonResponse.error("该单据不能弃审/撤回!");
		}
		PayContractEntity entity = service.selectById(billId);
		// 校验审批时间


		if (!validateApproveTime(entity)) return CommonResponse.error("该合同在本组织下非最新付款申请，不能撤回!");
		// 校验存在未生效单据
		if (!validateEffective(entity)) return CommonResponse.error("该合同在本组织下存在未生效付款申请，不能撤回!");

		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		if(res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PayContractEntity applyEntity = service.selectById(billId);
		applyEntity.setPayMny(BigDecimal.ZERO);//支付金额
		applyEntity.setUnPayMny(ComputeUtil.safeSub(applyEntity.getApplyMny(),applyEntity.getPayMny()));//未支付金额
		applyEntity.setConfirmTime(null);
		service.updateById(applyEntity);
		// 删除付款记录表
		recordService.remove(new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId));
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 校验存在未生效单据
	 * @param entity
	 * @return
	 */
	private boolean validateEffective(PayContractEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		wrapper.ne("bill_state", 1);
		wrapper.ne("bill_state", 3);
		List<PayContractEntity> list = service.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}

	/**
	 * 校验审批时间
	 * @param entity
	 * @return
	 */
	private boolean validateApproveTime(PayContractEntity entity) {
		Long contractId = entity.getContractId();
		QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
		wrapper.eq("contract_id", contractId);
		wrapper.eq("org_id", entity.getOrgId());
		wrapper.gt("apply_date", entity.getApplyDate());
		List<PayContractEntity> list = service.list(wrapper);
		if(!list.isEmpty()){
			return false;
		}
		return true;
	}
}
