package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.OccupyMapper;
import com.ejianc.business.finance.service.IOccupyService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 出纳资金-占用资金表-主表
 * 
 * @author generator
 * 
 */
@Service("occupyService")
public class OccupyServiceImpl extends BaseServiceImpl<OccupyMapper, OccupyEntity> implements IOccupyService{
    @Autowired
    private IReceiveService receiveService;
    @Override
    public OccupyVO queryData() {
        OccupyEntity occupyEntity = new OccupyEntity();
        occupyEntity.setId(IdWorker.getId());

        //查询收款登记
        List<String> list = new ArrayList<>();
        list.add("合同收款");
        list.add("保证金");
        list.add("项目经理自存款");
        list.add("其他");
        LambdaQueryWrapper<ReceiveEntity> lambdaReceiveWrapper = new LambdaQueryWrapper<>();
        lambdaReceiveWrapper.in(ReceiveEntity::getBillState,1,3);
        lambdaReceiveWrapper.in(ReceiveEntity::getReceiveKindName,list);
        List<ReceiveEntity> receiveEntityList = receiveService.list(lambdaReceiveWrapper);
        Map<String,List<ReceiveEntity>> receiveMap = new HashMap<>();
        List<OccupyDetailEntity> occupyDetailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(receiveEntityList)){

            // 分组后汇总
            // 查询工程计量台账往期值
            receiveMap= receiveEntityList.stream().collect(
                        Collectors.groupingBy(
                                s->s.getProjectId() + "-" + s.getReceiveKindName()
                        ));
            receiveMap.forEach((receiveKey,receiveList)->{
                OccupyDetailEntity occupyDetailEntity = new OccupyDetailEntity();
                List<ReceiveEntity> receiveEntities = receiveList.stream().sorted(Comparator.comparing(ReceiveEntity::getConfirmTime).reversed())
                        .collect(Collectors.toList());
                ReceiveEntity receiveEntity = receiveEntities.stream().findFirst().get();
                occupyDetailEntity.setInDate(receiveEntity.getConfirmTime());
                occupyDetailEntity.setPayTypeId(receiveEntity.getReceiveKind());
                if (receiveEntity.getReceiveKindName().equals("合同收款")){
                    occupyDetailEntity.setPayTypeName("工程款");
                }
                if (receiveEntity.getReceiveKindName().equals("保证金")){
                    occupyDetailEntity.setPayTypeName("保证金");
                }
                if (receiveEntity.getReceiveKindName().equals("项目经理自存款")){
                    occupyDetailEntity.setPayTypeName("代付材料款");
                }
                if (receiveEntity.getReceiveKindName().equals("其他")){
                    occupyDetailEntity.setPayTypeName("其他");
                }
                occupyDetailEntity.setProjectId(receiveEntity.getProjectId());
                occupyDetailEntity.setProjectName(receiveEntity.getProjectName());
                occupyDetailEntity.setOrgId(receiveEntity.getOrgId());
                occupyDetailEntity.setOrgName(receiveEntity.getOrgName());
                BigDecimal receiveMny = receiveEntities.stream().filter(s->s.getReceiveMny() != null).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                occupyDetailEntity.setMoney(receiveMny);
                occupyDetailEntity.setId(IdWorker.getId());
                occupyDetailEntity.setMid(occupyEntity.getId());
                occupyDetailEntityList.add(occupyDetailEntity);
            });

            BigDecimal money = occupyDetailEntityList.stream().filter(s->s.getMoney() != null).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOccupyMny(money);

            //查询往期值
            LambdaQueryWrapper<OccupyEntity> lambdaLastWrapper = new LambdaQueryWrapper<>();
            lambdaLastWrapper.in(OccupyEntity::getBillState,1,3);
            lambdaLastWrapper.orderByDesc(OccupyEntity::getDate);
            List<OccupyEntity> daypayEntityList = super.list(lambdaLastWrapper);
            BigDecimal occupyLastMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(daypayEntityList)){
                OccupyEntity occupyLastEntity = daypayEntityList.stream().findFirst().get();
                occupyLastMny = occupyLastEntity.getOccupyMny();
                //查询往期值
            }
            if (money.compareTo(ComputeUtil.nullToZero(occupyLastMny)) > -1){
                occupyEntity.setUpMny(ComputeUtil.safeSub(money,occupyLastMny));
            }else{
                occupyEntity.setDownMny(ComputeUtil.safeSub(occupyLastMny,money));
            }
            //工程款
            BigDecimal projectMny = occupyDetailEntityList.stream().filter(s->s.getMoney() != null && s.getPayTypeName().equals("工程款")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setProjectMny(projectMny);
            //保证金
            BigDecimal bailMny = occupyDetailEntityList.stream().filter(s->s.getMoney() != null && s.getPayTypeName().equals("保证金")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setBailMny(bailMny);
            //代付材料款
            BigDecimal materialMny = occupyDetailEntityList.stream().filter(s->s.getMoney() != null && s.getPayTypeName().equals("代付材料款")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setMaterialMny(materialMny);
            //代付材料款
            BigDecimal otherMny = occupyDetailEntityList.stream().filter(s->s.getMoney() != null && s.getPayTypeName().equals("其他")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOtherMny(otherMny);

            occupyEntity.setOccupyDetailList(occupyDetailEntityList);
        }
        OccupyVO occupyVO = BeanMapper.map(occupyEntity, OccupyVO.class);
        return occupyVO;
    }
}
