package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.TenderFileMapper;
import com.ejianc.business.bid.bean.TenderFileEntity;
import com.ejianc.business.bid.service.ITenderFileService;

import java.util.List;

/**
 * 投标管理-资料上传实体
 * 
 * @author generator
 * 
 */
@Service("tenderFileService")
public class TenderFileServiceImpl extends BaseServiceImpl<TenderFileMapper, TenderFileEntity> implements ITenderFileService{

    @Override
    public List<TenderFileEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<TenderFileEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.orderByDesc("create_time");

        return super.list(query);
    }
}
