package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bid.bean.BidPersonAffirmEntity;
import com.ejianc.business.bid.mapper.BidPersonAffirmMapper;
import com.ejianc.business.bid.service.IBidPersonAffirmService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 投标管理-确认标书员
 * 
 * @author generator
 * 
 */
@Service("bidPersonAffirmService")
public class BidPersonAffirmServiceImpl extends BaseServiceImpl<BidPersonAffirmMapper, BidPersonAffirmEntity> implements IBidPersonAffirmService{

    @Override
    public List<BidPersonAffirmEntity> getByBusOpportunityId(Long id) {
        QueryWrapper<BidPersonAffirmEntity> query = new QueryWrapper<>();
        query.eq("opportunity_id", id);
        query.orderByDesc("create_time");
        return super.list(query);
    }
}
