package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.CertRecordDetailEntity;
/**
 * 人力行政-证书档案
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_cert_record")
public class CertRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="human_type")
    private Integer humanType; // 人员类别（1内部2外部）
    @TableField(value="human_type_name")
    private String humanTypeName; // 人员类别
    @TableField(value="human_pay_id")
    private Long humanPayId; // 姓名
    @TableField(value="human_pay_name")
    private String humanPayName; // 姓名
    @TableField(value="phone")
    private String phone; // 移动电话
    @TableField(value="sex")
    private Integer sex; // 性别 1：男 2：女
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_name")
    private String orgName; // 组织
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="major")
    private String major; // 所学专业
    @TableField(value="educated")
    private String educated; // 最高学历
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="certRecordDetailService",pidName = "recordId")
    private List<CertRecordDetailEntity> certRecordDetailList = new ArrayList<>(); // 人力行政-证书档案-证件信息
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }

    public Long getHumanPayId() {
        return humanPayId;
    }

    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<CertRecordDetailEntity> getCertRecordDetailList() {
        return certRecordDetailList;
    }

    public void setCertRecordDetailList(List<CertRecordDetailEntity> certRecordDetailList) {
        this.certRecordDetailList = certRecordDetailList;
    }
}
