package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.bid.bean.BidOpenResultEntity;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.TenderFileEntity;
import com.ejianc.business.bid.service.IBidOpenResultService;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.ITenderFileService;
import com.ejianc.business.bid.vo.BidOpenResultVO;
import com.ejianc.business.bid.vo.BusOpportunityVO;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.BackFeeMapper;
import com.ejianc.business.oa.bean.BackFeeEntity;
import com.ejianc.business.oa.service.IBackFeeService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力行政-退費申请表
 *
 * @author generator
 */
@Service("backFeeService")
public class BackFeeServiceImpl extends BaseServiceImpl<BackFeeMapper, BackFeeEntity> implements IBackFeeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegisterService projectRegisterService;
    @Autowired
    private IBusOpportunityService busOpportunityService;
    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBidOpenResultService bidOpenResultService;

    @Autowired
    private ITenderFileService tenderFileService;

    private final String northeastRegion = "东北大区";
    private final Integer ORG_TYPE_PROJECT_MANAGER_ORG = 3;

    @Override
    public JSONObject queryDetailByProjectId(Long projectId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("followPersonMmy", new BigDecimal(0));
        jsonObject.put("documenterMmy", new BigDecimal(0));
        jsonObject.put("authMmy", new BigDecimal(0));
        jsonObject.put("qualificationMmy", new BigDecimal(0));
        jsonObject.put("qualificationBackMmy", new BigDecimal(0));
        jsonObject.put("bidDocMny", new BigDecimal(0));
        jsonObject.put("bidDocBackMny", new BigDecimal(0));
        jsonObject.put("backMny", new BigDecimal(0));

        ProjectRegisterEntity projectRegisterEntity = projectRegisterService.selectById(projectId);
        if (null != projectRegisterEntity.getOpportunityId()) {
            BusOpportunityEntity bp = busOpportunityService.selectById(projectRegisterEntity.getOpportunityId());
            jsonObject.put("registrationDate", DateUtil.format(bp.getRegistrationDate(),DateUtil.DATE_TIME));
            jsonObject.put("openTenderDate",DateUtil.format(bp.getOpenTenderDate(),DateUtil.DATE_TIME));
            jsonObject.put("biddingControlMmy",bp.getBiddingControlMmy() );
            jsonObject.put("provinceId",bp.getProvinceId() );
            jsonObject.put("provinceName",bp.getProvinceName() );
            jsonObject.put("followPersonId",bp.getFollowPersonId() );
            jsonObject.put("followPerson",bp.getFollowPerson() );
            Set<Long> emplyeeIds = new HashSet<>();
            Map<Long, EmployeeVO> empIdMap = new HashMap<>();
            Set<Long> orgIds = new HashSet<>();
            Map<Long, OrgVO> orgIdMap = new HashMap<>();
            if (null != bp.getFollowPersonId()) {
                emplyeeIds.add(bp.getFollowPersonId()); //业务经理
            }
            if (null != bp.getDocumenterId()) {
                emplyeeIds.add(bp.getDocumenterId()); //资料员
            }
            if (null != bp.getNetAuthPersonId()) {
                emplyeeIds.add(bp.getNetAuthPersonId()); //网开授权人

            }
            if (null != bp.getSiteAuthPersonId()) { //现场授权人
                emplyeeIds.add(bp.getSiteAuthPersonId());
            }
            if (CollectionUtils.isNotEmpty(emplyeeIds)) {
                CommonResponse<List<EmployeeVO>> empList = employeeApi.getByIds(new ArrayList<>(emplyeeIds));
                if (!empList.isSuccess()) {
                    logger.error("根据人员id列表{}查询人员信息失败", JSONObject.toJSONString(emplyeeIds), JSONObject.toJSONString(empList));
                }
                if (CollectionUtils.isNotEmpty(empList.getData())) {
                    for (EmployeeVO employee : empList.getData()) {
                        empIdMap.put(employee.getId(), employee);
                        orgIds.add(employee.getOrgId());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(orgIds)) {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findAllByIds(new ArrayList<>(orgIds));
                if (!orgResp.isSuccess()) {
                    logger.error("根据组织id列表{}查询人员信息失败", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp));
                }
                orgIdMap.putAll(orgResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
            /**
             * 授权人提成
             */
            List<BidOpenResultEntity> openResultList = bidOpenResultService.getByBusOpportunityId(bp.getId());
            if (CollectionUtils.isNotEmpty(openResultList)) {
                BidOpenResultEntity result = openResultList.get(0);
                EmployeeVO tmpEmp = null;
                if (BidOpenResultVO.OPEN_TYPE_NET.equals(result.getBidOpenType())) {
                    //网开
                    if (null != bp.getNetAuthPersonId()) {
                        tmpEmp = empIdMap.get(bp.getNetAuthPersonId());
                    }
                } else {
                    //现场
                    if (null != bp.getSiteAuthPersonId()) {
                        tmpEmp = empIdMap.get(bp.getNetAuthPersonId());
                    }
                }
                if (null == tmpEmp) {
                    logger.error("商机登记单id-{} 授权人id-{}，授权人类型：{}, 查询为空，跳过处理~", bp.getId(), bp.getDocumenterId(), result.getBidOpenType());
                } else {
                    if (northeastRegion.equals(tmpEmp.getOrgName())) {
                        jsonObject.put("authMmy",
                                new BigDecimal(BidOpenResultVO.OPEN_TYPE_NET.equals(result.getBidOpenType()) ? "40" : "100"));
                    } else {
                        logger.error("商机登记单id-{} 授权人id-{}，授权人类型：{}, 直属组织非东北大区，跳过处理~", bp.getId(), bp.getDocumenterId(), result.getBidOpenType());
                    }
                }
            } else {
                logger.error("商机登记单id-{} 不存在生效的开包记录，跳过处理~", bp.getId(), bp.getDocumenterId());
            }
            /**
             * 资料员提成
             */
            if (null != bp.getDocumenterId() && empIdMap.containsKey(bp.getDocumenterId())) {
                EmployeeVO tmpEmp = empIdMap.get(bp.getDocumenterId());

                if (northeastRegion.equals(tmpEmp.getOrgName())) {
                    if (orgIdMap.containsKey(bp.getOrgId()) && !ORG_TYPE_PROJECT_MANAGER_ORG.equals(orgIdMap.get(bp.getOrgId()).getOrgType())) {
                        //商机登记商机组织
                        //查询是否有生效的资料上传单据
                        List<TenderFileEntity> fileList = tenderFileService.getByBusOpportunityId(bp.getId());
                        if (CollectionUtils.isNotEmpty(fileList)) {
                            jsonObject.put("documenterMmy", new BigDecimal("40"));
                        } else {
                            logger.error("商机登记单id-{} 没有生效的资料上传单据，跳过处理~", bp.getId(), bp.getOrgId());
                        }
                    } else {
                        logger.error("商机登记单id-{} 所属组织id-{}类型为办事处，跳过处理~", bp.getId(), bp.getOrgId());
                    }
                } else {
                    logger.error("商机登记单id-{} 资料员id-{}直属组织不是东北大区，跳过处理~", bp.getId(), bp.getDocumenterId());
                }
            } else {
                logger.error("商机登记单id-{} 资料员id-{}查询为空，跳过处理~", bp.getId(), bp.getDocumenterId());
            }


            /**
             * 业务经理提成
             */
            jsonObject.put("followPersonMmy", ComputeUtil.safeSub(ComputeUtil.safeMultiply(bp.getQualificationFee(), new BigDecimal("0.25")),
                    (BigDecimal) jsonObject.get("authMmy")));


            jsonObject.put("qualificationMmy", ComputeUtil.nullToZero(bp.getQualificationFee()));
            jsonObject.put("bidDocMny", ComputeUtil.nullToZero(bp.getBiddingFee()));
            jsonObject.put("bidDocBackMny", new BigDecimal(0));

            jsonObject.put("qualificationBackMmy", ComputeUtil.safeSub(jsonObject.getBigDecimal("qualificationMmy")
                    , jsonObject.getBigDecimal("followPersonMmy"), jsonObject.getBigDecimal("documenterMmy"), jsonObject.getBigDecimal("bidDocMny")));

            jsonObject.put("backMny", ComputeUtil.safeAdd(jsonObject.getBigDecimal("qualificationBackMmy"), jsonObject.getBigDecimal("bidDocBackMny")));


        }
        return jsonObject;
    }
}
