package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.utils.CheckItemReformState;
import com.ejianc.business.scene.utils.GetAutoCode;
import com.ejianc.business.scene.utils.ReformState;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.vo.CheckBfyjVO;

/**
 * 现场监控-现场检查
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("checkBfyj")
public class CheckBfyjController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${oms.fileServerPath}")
    private String baseImgUrl;
    private static final String BILL_CODE = "BFYJ_XCJK_XCJC";//此处需要根据实际修改

    @Autowired
    private ICheckBfyjService service;

    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> saveOrUpdate(@RequestBody CheckBfyjVO saveorUpdateVO) {
        CheckBfyjEntity entity = BeanMapper.map(saveorUpdateVO, CheckBfyjEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //新增时整改状态设置为0
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        //获取子表
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //子表赋值
        int count = 0;
        for (CheckDetailBfyjEntity sceneCheckDetail : sceneCheckDetails) {
            if (sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState())) {
                count++;
                if (StringUtils.isBlank(sceneCheckDetail.getBillCode())) {
                    sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers(count));
                }
            }
            //检查单名称
            if (StringUtils.isBlank(sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            //项目名称
            if (StringUtils.isBlank(sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            //检查项设置默认的整改标识
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() == null) {
                sceneCheckDetail.setReformNumber(0);
            }

            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());

        }
        entity.setReviewItem(count);
        service.saveOrUpdate(entity, false);

        List<CheckDetailBfyjEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List<CheckDetailBfyjVO> CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails1, CheckDetailBfyjVO.class);
        CheckDetailBfyjVOList.forEach((item) -> {
            item.setBaseImgUrl(baseImgUrl);
        });
        CheckBfyjVO vo = BeanMapper.map(entity, CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> queryDetail(@RequestParam Long id) {
        CheckBfyjEntity entity = service.selectById(id);
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<CheckDetailBfyjVO> CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails, CheckDetailBfyjVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            CheckDetailBfyjVOList.forEach((item) -> {
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        CheckBfyjVO vo = BeanMapper.map(entity, CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckBfyjVO> vos) {
        service.removeByIds(vos.stream().map(CheckBfyjVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<CheckBfyjEntity> page = service.queryPage(param, false);
        IPage<CheckBfyjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckBfyjVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");

        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CheckBfyjEntity> list = service.queryList(param);
        List<CheckBfyjVO> CheckBfyjVOS = BeanMapper.mapList(list, CheckBfyjVO.class);
        if (CollectionUtils.isNotEmpty(CheckBfyjVOS)) {
            CheckBfyjVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel().intValue() ? "项目" : "公司");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", CheckBfyjVOS);
        ExcelExport.getInstance().exportWithTrans("SceneCheckbfyj-export.xlsx", beans, response);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCheckBfyjData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> refCheckBfyjData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CheckBfyjEntity> page = service.queryPage(param,false);
        IPage<CheckBfyjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckBfyjVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
