package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.CheckDetailBfyjEntity;
import com.ejianc.business.scene.bean.CheckBfyjEntity;
import com.ejianc.business.scene.bean.CheckRecordBfyjEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ICheckBfyjService;
import com.ejianc.business.scene.service.ICheckDetailBfyjService;
import com.ejianc.business.scene.service.ICheckRecordBfyjService;
import com.ejianc.business.scene.utils.*;
import com.ejianc.business.scene.vo.CheckDetailBfyjVO;
import com.ejianc.business.scene.vo.CheckBfyjVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("review")
public class ReviewController {

    @Autowired
    private ICheckBfyjService service;
    @Autowired
    private ICheckDetailBfyjService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICheckRecordBfyjService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private CheckMessageService checkMessageService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;



    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> queryDetail(@RequestParam Long id) {
        CheckBfyjEntity entity = service.selectById(id);
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<CheckDetailBfyjVO> CheckDetailBfyjVOList = BeanMapper.mapList(sceneCheckDetails, CheckDetailBfyjVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails))
        {
            CheckDetailBfyjVOList.forEach(item->{
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        CheckBfyjVO vo = BeanMapper.map(entity, CheckBfyjVO.class);
        vo.setSceneCheckDetails(CheckDetailBfyjVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckBfyjVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
       // param.getParams().put("review_id", new Parameter(QueryParam.LIKE, sessionManager.getUserContext().getUserId().toString()));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("review_id", new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getUserId().toString()));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("review_id", new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getEmployeeId().toString()));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        param.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

        IPage<CheckBfyjEntity> page = service.queryPage(param, false);
        IPage<CheckBfyjVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckBfyjVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> submitReviewNews( @RequestBody CheckBfyjVO param) {
        CheckBfyjEntity entity = BeanMapper.map(param, CheckBfyjEntity.class);
        CheckBfyjVO vo = BeanMapper.map(entity, CheckBfyjVO.class);
        LambdaUpdateWrapper<CheckBfyjEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(CheckBfyjEntity::getId, entity.getId());
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(CheckDetailBfyjEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            List<CheckRecordBfyjEntity> list = new ArrayList<>();
            List<CheckDetailBfyjEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(CheckBfyjEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(sceneCheckDetailList.size());
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId!=null){
                    String[] reformDutyIds = reformDutyId.split(",");
                    checkMessageService.sendMsg(vo,reformDutyIds,NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(CheckBfyjEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                //设置复检信息
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId!=null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(0);
                    checkMessageService.sendMsg(vo,notifRelevantIds,NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            //生成复查信息
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    CheckRecordBfyjEntity sceneCheckRecord = new CheckRecordBfyjEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    //设置操作状态
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                sceneCheckRecordService.saveBatch(list, list.size());
            }




            //解除文件服务器和待整改的绑定
            sceneCheckDetails.forEach(sceneCheckitem->{
                if (ReviewState.REVIEW_FAILED_STATE.getCode().equals(sceneCheckitem.getReviewResult())){
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("pid", new Parameter(QueryParam.EQ,sceneCheckitem.getId() ));
                    queryParam.getOrderMap().put("createTime", QueryParam.DESC);
                    queryParam.getParams().put("operation_type", new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));

                    List<CheckRecordBfyjEntity> sceneCheckRecords = sceneCheckRecordService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty(sceneCheckRecords)) {
                        System.out.println(sceneCheckRecords);
                        CheckRecordBfyjEntity CheckRecordBfyjEntity = sceneCheckRecords.get(0);
                        if (CheckRecordBfyjEntity.getImgIds()!=null)
                        {
                            List<String> imgids = Arrays.asList(CheckRecordBfyjEntity.getImgIds().split(","));
                            List<Long> attachIds = new ArrayList<>();
                            imgids.forEach(item->{
                                attachIds.add(Long.parseLong(item));
                            });
                            iAttachmentApi.updateAttachRef(CheckRecordBfyjEntity.getId(), attachIds);
                        }
                    }
                }
            });


            //设置（检查结果）复查信息
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper<CheckDetailBfyjEntity> updateReviewMsgWrapper = new LambdaUpdateWrapper<>();
                updateReviewMsgWrapper.eq(CheckDetailBfyjEntity::getId, item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty(item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(CheckDetailBfyjEntity::getReviewMsg, item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe);
                Integer reviewResult = item.getReviewResult();
                sceneCheckDetailService.update(updateReviewMsgWrapper);
            });
        }
        //复检结果为复查不合格或者合格  isModify 修改为1 待复检为 0
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper<CheckDetailBfyjEntity> isModifyWrapper = new LambdaUpdateWrapper<>();
                isModifyWrapper.eq(CheckDetailBfyjEntity::getId, item.getId());
                isModifyWrapper.set(CheckDetailBfyjEntity::getIsModify, Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                sceneCheckDetailService.update(isModifyWrapper);
            }
        });
        System.out.println("=============");
        System.out.println(sceneCheckDetails);
        //设置 整改状态  检查结果状态描述
        sceneCheckDetails.forEach(item -> {
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper<CheckDetailBfyjEntity> sceneUpdateWrapper = new LambdaUpdateWrapper<>();
                sceneUpdateWrapper.eq(CheckDetailBfyjEntity::getId, item.getId());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getReviewDate,new Date());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getTaskState, CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(CheckDetailBfyjEntity::getReviewResult, ReviewState.REVIEW_FAILED_STATE.getCode());
                sceneCheckDetailService.update(sceneUpdateWrapper);
            }
            //合格设置为3
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper<CheckDetailBfyjEntity> successWrapper = new LambdaUpdateWrapper<>();
                successWrapper.eq(CheckDetailBfyjEntity::getId, item.getId());
                successWrapper.set(CheckDetailBfyjEntity::getTaskState, CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());

                successWrapper.set(CheckDetailBfyjEntity::getReviewResult, ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(CheckDetailBfyjEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate()==null)
                {
                    successWrapper.set(CheckDetailBfyjEntity::getReviewDate,new Date());
                }
                sceneCheckDetailService.update(successWrapper);
            }
        });
        //分组
        Map<Integer, List<CheckDetailBfyjEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(CheckDetailBfyjEntity::getReviewResult));

        //设置已提交
        updateWrapper.set(CheckBfyjEntity::getReviewStatus, Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            //设置已完成  合格的
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper<CheckBfyjEntity> revieweFinishedWrapper = new LambdaUpdateWrapper<>();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(CheckBfyjEntity::getReviewPass, reviewFinished);
                revieweFinishedWrapper.eq(CheckBfyjEntity::getId, entity.getId());
                boolean update = service.update(revieweFinishedWrapper);
            }
            //设置已复查（合格不合格的）
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper<CheckBfyjEntity> revieweFailedWrapper = new LambdaUpdateWrapper<>();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(CheckBfyjEntity::getReviewedNum, size);
                revieweFailedWrapper.eq(CheckBfyjEntity::getId, entity.getId());
                boolean update = service.update(revieweFailedWrapper);
            }
        }

        boolean update = service.update(updateWrapper);
        if (update) {
            Long id = entity.getId();
            CheckBfyjEntity checkenEntity = service.selectById(id);
            CheckBfyjVO CheckBfyjVO = BeanMapper.map(checkenEntity, CheckBfyjVO.class);
            return CommonResponse.success("提交成功！", CheckBfyjVO);
        }
        return CommonResponse.error("提交失败！");
    }


    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckBfyjVO> saveReviewNews( @RequestBody CheckBfyjVO param) {
        CheckBfyjEntity entity = BeanMapper.map(param, CheckBfyjEntity.class);
        List<CheckDetailBfyjEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //设置，复查结果，复查描述，复查图片 信息  /设置当前登录人为实际复查人
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<CheckDetailBfyjEntity> updateWrapper = new LambdaUpdateWrapper<>();
                String userName = sessionManager.getUserContext().getUserName();
                updateWrapper.set(CheckDetailBfyjEntity::getActualReviewer, userName);
                updateWrapper.eq(CheckDetailBfyjEntity::getId, sceneCheckDetail.getId());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewResult, sceneCheckDetail.getReviewResult());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewDescribe, sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewImgIds, sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(CheckDetailBfyjEntity::getReviewImgUrl, sceneCheckDetail.getReviewImgUrl());
                sceneCheckDetailService.update(updateWrapper);
            });
        }
        Long id = entity.getId();
        CheckBfyjEntity sceneCheck = service.selectById(id);
        CheckBfyjVO vo = BeanMapper.map(sceneCheck, CheckBfyjVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


}
