/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.bean.ContractChangeEntity;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.mapper.ContractChangeMapper;
import com.ejianc.business.contract.service.IContractChangeService;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.utils.BillCodeSetEnum;
import com.ejianc.business.contract.vo.ContractChangeVO;
import com.ejianc.business.contract.vo.ContractRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    @Autowired
    private IContractManageService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractChangeService service;

    @Override
    public ContractChangeVO addConvertByConId(Long contractId) {
        ContractManageEntity contractVO = (ContractManageEntity)((Object)this.contractService.selectById(contractId));
        ContractChangeVO changeVO = (ContractChangeVO)BeanMapper.map((Object)((Object)contractVO), ContractChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractVO.getContractName());
        changeVO.setBeforeChangeMny(contractVO.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractVO.getContractTaxMny());
        changeVO.setContractId(changeVO.getId());
        changeVO.setChangeVersion(Integer.valueOf(contractVO.getChangeVersion() == null ? 1 : contractVO.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(Long.valueOf(IdWorker.getId()));
        return changeVO;
    }

    @Override
    public ContractChangeVO insertOrUpdate(ContractChangeVO changeVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        int count = 0;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)changeVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BillCodeSetEnum.getEnumByContractType(changeVO.getContractType()).getBillCode(), InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (changeVO.getId() != null && changeVO.getId() > 0L && this.service.getById(changeVO.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(ContractChangeEntity::getContractId, (Object)changeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            queryWrapper.eq(ContractManageEntity::getBillCode, (Object)changeVO.getBillCode());
            queryWrapper.ne(BaseEntity::getId, (Object)changeVO.getContractId());
            count = this.contractService.count((Wrapper)queryWrapper);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, (Object)changeVO.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId, (Object)changeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
            queryWrapper.eq(ContractManageEntity::getBillCode, (Object)changeVO.getBillCode());
            queryWrapper.ne(BaseEntity::getId, (Object)changeVO.getContractId());
            count = this.contractService.count((Wrapper)queryWrapper);
        }
        if (entities != null && entities.size() > 0 && count > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)BeanMapper.map((Object)changeVO, ContractChangeEntity.class));
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveWriteContract(changeEntity);
        return (ContractChangeVO)BeanMapper.map((Object)((Object)changeEntity), ContractChangeVO.class);
    }

    @Override
    public ContractRecordVO queryDetailRecord(Long id) {
        BigDecimal sumChangeMny;
        ContractManageEntity contractEntity = (ContractManageEntity)((Object)this.contractService.selectById(id));
        ContractRecordVO changeRecordVO = new ContractRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        changeRecordVO.setContractId(id);
        changeRecordVO.setContractTaxMny(contractTaxMny);
        changeRecordVO.setBaseTaxMoney(baseTaxMny);
        changeRecordVO.setContractStatus(contractEntity.getContractStatus());
        changeRecordVO.setChangeStatus(contractEntity.getChangeStatus());
        changeRecordVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        BigDecimal bigDecimal = sumChangeMny = changeRecordVO.getSumChangeMny() == null ? BigDecimal.ZERO : changeRecordVO.getSumChangeMny();
        if (sumChangeMny.compareTo(BigDecimal.ZERO) != 0 && baseTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal sumScale = sumChangeMny.divide(baseTaxMny, 8, 5).multiply(new BigDecimal(100));
            changeRecordVO.setSumScale(sumScale);
        }
        if (null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getContractId, (Object)id);
            lambda.in(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List entities = super.list((Wrapper)lambda);
            entities.forEach(changevo -> {
                if (changevo.getChangeVersion() < 10) {
                    changevo.setBillCode(changevo.getBillCode() + "-0" + changevo.getChangeVersion());
                } else {
                    changevo.setBillCode(changevo.getBillCode() + "-" + changevo.getChangeVersion());
                }
            });
            changeRecordVO.setDetailList(BeanMapper.mapList((Iterable)entities, ContractRecordVO.class));
        }
        return changeRecordVO;
    }

    private void saveWriteContract(ContractChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractManageEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(ContractManageEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractManageEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractManageEntity::getChangeStatus, (Object)2);
        updateWrapper.set(ContractManageEntity::getChangingMny, (Object)changeEntity.getContractMny());
        updateWrapper.set(ContractManageEntity::getChangingTaxMny, (Object)changeEntity.getContractTaxMny());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }
}

