/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.AccountRegisterEntity;
import com.ejianc.business.finance.bean.DaypayDetailEntity;
import com.ejianc.business.finance.bean.DaypayEntity;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.bean.InternalExchangeEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.mapper.DaypayMapper;
import com.ejianc.business.finance.service.IAccountRegisterService;
import com.ejianc.business.finance.service.IDaypayDetailService;
import com.ejianc.business.finance.service.IDaypayService;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.IInternalExchangeService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.DaypayVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="daypayService")
public class DaypayServiceImpl
extends BaseServiceImpl<DaypayMapper, DaypayEntity>
implements IDaypayService {
    @Autowired
    private IAccountRegisterService accountRegisterService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IInternalExchangeService internalExchangeService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IDeductionService deductionService;
    @Autowired
    private IDaypayDetailService daypayDetailService;

    @Override
    public DaypayVO queryData() {
        LambdaQueryWrapper lambdaAccountWrapper = new LambdaQueryWrapper();
        lambdaAccountWrapper.in(AccountRegisterEntity::getBillState, new Object[]{1, 3});
        List accountRegisterEntities = this.accountRegisterService.list((Wrapper)lambdaAccountWrapper);
        LambdaQueryWrapper lambdaReceiveWrapper = new LambdaQueryWrapper();
        lambdaReceiveWrapper.in(ReceiveEntity::getBillState, new Object[]{1, 3});
        List receiveEntityList = this.receiveService.list((Wrapper)lambdaReceiveWrapper);
        Map<Object, Object> receiveMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)receiveEntityList)) {
            receiveMap = receiveEntityList.stream().filter(s -> s.getAccountId() != null).collect(Collectors.groupingBy(ReceiveEntity::getAccountId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getReceiveMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaExchangeWrapper = new LambdaQueryWrapper();
        lambdaExchangeWrapper.in(InternalExchangeEntity::getBillState, new Object[]{1, 3});
        List exchangeEntityList = this.internalExchangeService.list((Wrapper)lambdaExchangeWrapper);
        Map<Object, Object> exchangeInMap = new HashMap();
        Map<Object, Object> exchangeOutMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)exchangeEntityList)) {
            exchangeInMap = exchangeEntityList.stream().filter(s -> s.getInAccountRegisterId() != null).collect(Collectors.groupingBy(InternalExchangeEntity::getInAccountRegisterId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            exchangeOutMap = exchangeEntityList.stream().filter(s -> s.getAccountRegisterId() != null).collect(Collectors.groupingBy(InternalExchangeEntity::getAccountRegisterId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        List payRecordEntityList = this.payRecordService.list((Wrapper)lambdaRecord);
        Map<Object, Object> payRecordMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)payRecordEntityList)) {
            payRecordMap = payRecordEntityList.stream().filter(s -> s.getAccountRegisterId() != null).collect(Collectors.groupingBy(PayRecordEntity::getAccountRegisterId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getThisPayMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaDeduction = Wrappers.lambdaQuery();
        List deductionEntityList = this.deductionService.list((Wrapper)lambdaDeduction);
        Map<Object, Object> deductionMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)deductionEntityList)) {
            deductionMap = deductionEntityList.stream().filter(s -> s.getAccountRegisterId() != null).collect(Collectors.groupingBy(DeductionEntity::getAccountRegisterId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAccountMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper lambdaLastWrapper = new LambdaQueryWrapper();
        lambdaLastWrapper.in(DaypayEntity::getBillState, new Object[]{1, 3});
        lambdaLastWrapper.orderByDesc(DaypayEntity::getDate);
        List daypayEntityList = super.list((Wrapper)lambdaLastWrapper);
        Map<Object, Object> daypayDetailLastMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)daypayEntityList)) {
            DaypayEntity daypayEntity = (DaypayEntity)((Object)daypayEntityList.stream().findFirst().get());
            LambdaQueryWrapper lambdaLastDetailWrapper = new LambdaQueryWrapper();
            lambdaLastDetailWrapper.in(DaypayDetailEntity::getMid, new Object[]{daypayEntity.getId()});
            List daypayDetailEntities = this.daypayDetailService.list((Wrapper)lambdaLastDetailWrapper);
            if (CollectionUtils.isNotEmpty((Collection)daypayDetailEntities)) {
                daypayDetailLastMap = daypayDetailEntities.stream().filter(s -> s.getBankId() != null).collect(Collectors.toMap(DaypayDetailEntity::getBankId, Function.identity()));
            }
        }
        ArrayList<DaypayDetailEntity> daypayDetailEntities = new ArrayList<DaypayDetailEntity>();
        DaypayEntity daypayEntity = new DaypayEntity();
        daypayEntity.setId(IdWorker.getId());
        if (CollectionUtils.isNotEmpty((Collection)accountRegisterEntities)) {
            for (AccountRegisterEntity accountRegisterEntity : accountRegisterEntities) {
                Long accountId = accountRegisterEntity.getId();
                DaypayDetailEntity daypayDetailEntity = new DaypayDetailEntity();
                daypayDetailEntity.setBankId(accountRegisterEntity.getId());
                daypayDetailEntity.setBankName(accountRegisterEntity.getAccountName());
                BigDecimal lastIncomeMoney = BigDecimal.ZERO;
                BigDecimal lastPayMoney = BigDecimal.ZERO;
                if (daypayDetailLastMap.containsKey(accountId)) {
                    DaypayDetailEntity lastDaypayDetailEntity = (DaypayDetailEntity)((Object)daypayDetailLastMap.get(accountId));
                    daypayDetailEntity.setStartMoney(lastDaypayDetailEntity.getEndMoney());
                    lastPayMoney = lastDaypayDetailEntity.getPayMoney();
                }
                BigDecimal receiveMoney = BigDecimal.ZERO;
                if (receiveMap.containsKey(accountId)) {
                    receiveMoney = (BigDecimal)receiveMap.get(accountId);
                }
                BigDecimal exchangeInMoney = BigDecimal.ZERO;
                if (exchangeInMap.containsKey(accountId)) {
                    exchangeInMoney = (BigDecimal)exchangeInMap.get(accountId);
                }
                daypayDetailEntity.setIncomeMoney(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)receiveMoney, (BigDecimal)exchangeInMoney), (BigDecimal)lastIncomeMoney));
                BigDecimal exchangeOutMoney = BigDecimal.ZERO;
                if (exchangeOutMap.containsKey(accountId)) {
                    exchangeOutMoney = (BigDecimal)exchangeOutMap.get(accountId);
                }
                BigDecimal recordOutMoney = BigDecimal.ZERO;
                if (payRecordMap.containsKey(accountId)) {
                    recordOutMoney = (BigDecimal)payRecordMap.get(accountId);
                }
                BigDecimal deductionMoney = BigDecimal.ZERO;
                if (deductionMap.containsKey(accountId)) {
                    deductionMoney = (BigDecimal)deductionMap.get(accountId);
                }
                BigDecimal outMny = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeAdd((BigDecimal)exchangeOutMoney, (BigDecimal)recordOutMoney), (BigDecimal)deductionMoney);
                daypayDetailEntity.setPayMoney(ComputeUtil.safeSub((BigDecimal)outMny, (BigDecimal)lastPayMoney));
                BigDecimal endMoney = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)daypayDetailEntity.getStartMoney(), (BigDecimal)daypayDetailEntity.getIncomeMoney()), (BigDecimal)daypayDetailEntity.getPayMoney());
                daypayDetailEntity.setEndMoney(endMoney);
                daypayDetailEntity.setId(IdWorker.getId());
                daypayDetailEntity.setMid(daypayEntity.getId());
                daypayDetailEntities.add(daypayDetailEntity);
            }
            daypayEntity.setDaypayDetailList(daypayDetailEntities);
            BigDecimal startMoney = daypayDetailEntities.stream().filter(s -> s.getStartMoney() != null).map(DaypayDetailEntity::getStartMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal endMoney = daypayDetailEntities.stream().filter(s -> s.getEndMoney() != null).map(DaypayDetailEntity::getEndMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            daypayEntity.setStartMny(startMoney);
            daypayEntity.setEndMny(endMoney);
        }
        DaypayVO daypayVO = (DaypayVO)BeanMapper.map((Object)((Object)daypayEntity), DaypayVO.class);
        return daypayVO;
    }
}

