package com.ejianc.business.contract.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contract.bean.ContractRecordEntity;
import com.ejianc.business.contract.service.IContractRecordService;
import com.ejianc.business.contract.utils.BillCodeSetEnum;
import com.ejianc.business.tax.bean.OuterCertEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.vo.ContractManageVO;

/**
 * 合同管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractManage")
public class ContractManageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IContractManageService service;
    @Autowired
    private IContractRecordService recordService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractManageVO> saveOrUpdate(@RequestBody ContractManageVO saveOrUpdateVO) {
    	ContractManageEntity entity = BeanMapper.map(saveOrUpdateVO, ContractManageEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BillCodeSetEnum.getEnumByContractType(entity.getContractType()).getBillCode(),InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        ContractManageVO vo= service.saveContract(entity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/queryRecordDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractManageVO> queryRecordDetail(Long id) {
        LambdaQueryWrapper<ContractRecordEntity> lambda = Wrappers.<ContractRecordEntity>lambdaQuery();
        lambda.eq(ContractRecordEntity::getChangeId, id);
        ContractRecordEntity contractEntity1 = recordService.getOne(lambda);
        ContractRecordEntity contractEntity = recordService.selectById(contractEntity1.getId());
        ContractManageVO contractVO =  BeanMapper.map(contractEntity, ContractManageVO.class);
        return CommonResponse.success("查询详情数据成功！", contractVO);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractManageVO> queryDetail(Long id) {
    	ContractManageEntity entity = service.selectById(id);
    	ContractManageVO vo = BeanMapper.map(entity, ContractManageVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @RequestMapping(value = "/querConByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractManageVO>> querConByProjectId(Long projectId) {
        LambdaQueryWrapper<ContractManageEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ContractManageEntity::getProjectId,projectId)
                .eq(ContractManageEntity::getDr,0)
                .in(ContractManageEntity::getBillState,1,3)
                .orderByDesc(ContractManageEntity::getCreateTime);
        List<ContractManageEntity> list = service.list(lambdaQueryWrapper);
        List<ContractManageVO> vo = BeanMapper.mapList(list, ContractManageVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryTotalConMnyBySupplierId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalConMnyBySupplierId(Long supplierId, Long projectId) {
        LambdaQueryWrapper<ContractManageEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ContractManageEntity::getSupplierId,supplierId)
                .eq(ContractManageEntity::getDr,0)
                .eq(null!=projectId,ContractManageEntity::getProjectId,projectId)
                .in(ContractManageEntity::getBillState,1,3);
        List<ContractManageEntity> list = service.list(lambdaQueryWrapper);
        BigDecimal sumConMny = list.stream().map(ContractManageEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CommonResponse.success("查询详情数据成功！",sumConMny);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractManageVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractManageVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractManageVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(getPageQueryParam(null));

        IPage<ContractManageEntity> pageData = service.queryPage(param,false);
        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractManageVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getComplexParams().add(getPageQueryParam(null));
        List<ContractManageEntity> entityList = service.queryList(param);
        List<ContractManageVO> list = BeanMapper.mapList(entityList, ContractManageVO.class);
        //todo:字段翻译等等
        //todo:字段翻译等等
        list.forEach(vo -> {
            if (null != vo.getContractStatus()) {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("未签订");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("履约中");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("已封账");
                }
            } else {
                vo.setContractStatusName("");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("ContractManage-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refContractManageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractManageVO>> refContractManageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        //只查询审批通过的合同
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 已封账，不能被参照到
        param.getParams().put("contractStatus", new Parameter(QueryParam.NE, 3));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectType")) {
                Integer projectType = Integer.valueOf(conditionMap.get("projectType").toString());
                param.getParams().put("projectType", new Parameter(QueryParam.EQ, projectType));
            }
            if (null != conditionMap.get("contractType")) {
                Integer contractType = Integer.valueOf(conditionMap.get("contractType").toString());
                param.getParams().put("contractType", new Parameter(QueryParam.EQ, contractType));
            }
        }
        param.getComplexParams().add(getPageQueryParam(null));
        IPage<ContractManageEntity> page = service.queryPage(param,false);
        IPage<ContractManageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractManageVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = iOrgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = iOrgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("project_type", new Parameter(QueryParam.EQ, 2));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

}
