/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.ProjectRegistrationEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.IProjectRegistrationService;
import com.ejianc.business.bid.vo.ProjectRegistrationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectRegistration"})
public class ProjectRegistrationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID-PROJECT-REGISTRATION";
    @Autowired
    private IProjectRegistrationService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBusOpportunityService busOpportunityService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<ProjectRegistrationVO> saveOrUpdate(@RequestBody ProjectRegistrationVO saveOrUpdateVO) {
        ProjectRegistrationEntity entity = (ProjectRegistrationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectRegistrationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCheckStatus("0");
            entity.setBillDate(new Date());
            entity.setFollowPerson(this.sessionManager.getUserContext().getEmployeeName());
            entity.setFollowPersonId(InvocationInfoProxy.getUserid());
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectRegistrationVO vo = (ProjectRegistrationVO)BeanMapper.map((Object)((Object)entity), ProjectRegistrationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ProjectRegistrationVO> queryDetail(Long id) {
        ProjectRegistrationEntity entity = (ProjectRegistrationEntity)((Object)this.service.selectById(id));
        ProjectRegistrationVO vo = (ProjectRegistrationVO)BeanMapper.map((Object)((Object)entity), ProjectRegistrationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ProjectRegistrationVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ProjectRegistrationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("area");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("area");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectRegistration-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectRegistrationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectRegistrationVO>> refProjectRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<BusOpportunityEntity> busList = this.busOpportunityService.getAllByRegistrationId(null, null);
        if (CollectionUtils.isNotEmpty(busList)) {
            param.getParams().put("id", new Parameter("not_in", new ArrayList(busList.stream().map(BusOpportunityEntity::getRegistrationId).collect(Collectors.toSet()))));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectRegistrationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"checkBill"})
    public CommonResponse<String> checkBill(@RequestBody Long billId) {
        ProjectRegistrationEntity entity = (ProjectRegistrationEntity)((Object)this.service.selectById(billId));
        if (null != entity.getBillState() && (entity.getBillState() == 1 || entity.getBillState() == 3) && "1".equals(entity.getCheckStatus())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5df2\u590d\u6838\uff01");
        }
        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        entity.setCheckStatus("1");
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(InvocationInfoProxy.getUsercode());
        entity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

