/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.finance.bean.OccupyDetailEntity;
import com.ejianc.business.finance.bean.OccupyEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.mapper.OccupyMapper;
import com.ejianc.business.finance.service.IOccupyService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.OccupyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="occupyService")
public class OccupyServiceImpl
extends BaseServiceImpl<OccupyMapper, OccupyEntity>
implements IOccupyService {
    @Autowired
    private IReceiveService receiveService;

    @Override
    public OccupyVO queryData() {
        OccupyEntity occupyEntity = new OccupyEntity();
        occupyEntity.setId(IdWorker.getId());
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u5408\u540c\u6536\u6b3e");
        list.add("\u4fdd\u8bc1\u91d1");
        list.add("\u9879\u76ee\u7ecf\u7406\u81ea\u5b58\u6b3e");
        list.add("\u5176\u4ed6");
        LambdaQueryWrapper lambdaReceiveWrapper = new LambdaQueryWrapper();
        lambdaReceiveWrapper.in(ReceiveEntity::getBillState, new Object[]{1, 3});
        lambdaReceiveWrapper.in(ReceiveEntity::getReceiveKindName, list);
        List receiveEntityList = this.receiveService.list((Wrapper)lambdaReceiveWrapper);
        Map<Object, Object> receiveMap = new HashMap();
        ArrayList<OccupyDetailEntity> occupyDetailEntityList = new ArrayList<OccupyDetailEntity>();
        if (CollectionUtils.isNotEmpty((Collection)receiveEntityList)) {
            receiveMap = receiveEntityList.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getReceiveKindName()));
            receiveMap.forEach((receiveKey, receiveList) -> {
                OccupyDetailEntity occupyDetailEntity = new OccupyDetailEntity();
                List receiveEntities = receiveList.stream().sorted(Comparator.comparing(ReceiveEntity::getConfirmTime).reversed()).collect(Collectors.toList());
                ReceiveEntity receiveEntity = (ReceiveEntity)((Object)((Object)receiveEntities.stream().findFirst().get()));
                occupyDetailEntity.setInDate(receiveEntity.getConfirmTime());
                occupyDetailEntity.setPayTypeId(receiveEntity.getReceiveKind());
                if (receiveEntity.getReceiveKindName().equals("\u5408\u540c\u6536\u6b3e")) {
                    occupyDetailEntity.setPayTypeName("\u5de5\u7a0b\u6b3e");
                }
                if (receiveEntity.getReceiveKindName().equals("\u4fdd\u8bc1\u91d1")) {
                    occupyDetailEntity.setPayTypeName("\u4fdd\u8bc1\u91d1");
                }
                if (receiveEntity.getReceiveKindName().equals("\u9879\u76ee\u7ecf\u7406\u81ea\u5b58\u6b3e")) {
                    occupyDetailEntity.setPayTypeName("\u4ee3\u4ed8\u6750\u6599\u6b3e");
                }
                if (receiveEntity.getReceiveKindName().equals("\u5176\u4ed6")) {
                    occupyDetailEntity.setPayTypeName("\u5176\u4ed6");
                }
                occupyDetailEntity.setProjectId(receiveEntity.getProjectId());
                occupyDetailEntity.setProjectName(receiveEntity.getProjectName());
                occupyDetailEntity.setOrgId(receiveEntity.getOrgId());
                occupyDetailEntity.setOrgName(receiveEntity.getOrgName());
                BigDecimal receiveMny = receiveEntities.stream().filter(s -> s.getReceiveMny() != null).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                occupyDetailEntity.setMoney(receiveMny);
                occupyDetailEntity.setId(IdWorker.getId());
                occupyDetailEntity.setMid(occupyEntity.getId());
                occupyDetailEntityList.add(occupyDetailEntity);
            });
            BigDecimal money = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOccupyMny(money);
            LambdaQueryWrapper lambdaLastWrapper = new LambdaQueryWrapper();
            lambdaLastWrapper.in(OccupyEntity::getBillState, new Object[]{1, 3});
            lambdaLastWrapper.orderByDesc(OccupyEntity::getDate);
            List daypayEntityList = super.list((Wrapper)lambdaLastWrapper);
            BigDecimal occupyLastMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)daypayEntityList)) {
                OccupyEntity occupyLastEntity = (OccupyEntity)((Object)daypayEntityList.stream().findFirst().get());
                occupyLastMny = occupyLastEntity.getOccupyMny();
            }
            if (money.compareTo(ComputeUtil.nullToZero((BigDecimal)occupyLastMny)) > -1) {
                occupyEntity.setUpMny(ComputeUtil.safeSub((BigDecimal)money, (BigDecimal)occupyLastMny));
            } else {
                occupyEntity.setDownMny(ComputeUtil.safeSub((BigDecimal)occupyLastMny, (BigDecimal)money));
            }
            BigDecimal projectMny = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null && s.getPayTypeName().equals("\u5de5\u7a0b\u6b3e")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setProjectMny(projectMny);
            BigDecimal bailMny = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null && s.getPayTypeName().equals("\u4fdd\u8bc1\u91d1")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setBailMny(bailMny);
            BigDecimal materialMny = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null && s.getPayTypeName().equals("\u4ee3\u4ed8\u6750\u6599\u6b3e")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setMaterialMny(materialMny);
            BigDecimal otherMny = occupyDetailEntityList.stream().filter(s -> s.getMoney() != null && s.getPayTypeName().equals("\u5176\u4ed6")).map(OccupyDetailEntity::getMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            occupyEntity.setOtherMny(otherMny);
            occupyEntity.setOccupyDetailList(occupyDetailEntityList);
        }
        OccupyVO occupyVO = (OccupyVO)BeanMapper.map((Object)((Object)occupyEntity), OccupyVO.class);
        return occupyVO;
    }
}

