package com.ejianc.business.bid.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.service.ICALockDetailService;
import com.ejianc.business.bid.vo.CALockDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 投标管理-CA锁登记子表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("cALockDetail")
public class CALockDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICALockDetailService service;
    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<CALockDetailVO>> queryList(@RequestBody QueryParam param) {

        IPage<CALockDetailVO> page = null;
        Map<String, Object> params = new HashMap<>();
        for(String key : param.getParams().keySet()) {
            switch (key) {
                case "handleTime":
                case "endTime":
                    params.put(key+"Start", param.getParams().get(key).getValue().toString().split(",")[0] + " 00:00:00");
                    params.put(key+"End", param.getParams().get(key).getValue().toString().split(",")[1]+ " 23:59:59");
                    break;
                case "lockTypes":
                    params.put(key+"End", param.getParams().get(key).getValue().toString().split(","));
                    break;
                default:
                    params.put(key, param.getParams().get(key).getValue());
            }
            if("handleTime".equals(key)) {

            } else {

            }
        }
        params.put("searchText", param.getSearchText());
        params.put("pageSize", param.getPageSize());
        params.put("startLine", param.getPageIndex() < 1 ? 0  : (param.getPageIndex() - 1) * param.getPageSize());
        Long count = service.countDetail(params);
        if(count == 0) {
            page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            page.setRecords(new ArrayList<>());
            return CommonResponse.success(page);
        }

        List<CALockDetailVO> detailList = service.pageList(params);
        page = new Page<>(param.getPageIndex(), param.getPageSize(), count);
        page.setRecords(detailList);

        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("acc");
        fuzzyFields.add("pwd");
        fuzzyFields.add("keerper");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Map<String, Object> params = new HashMap<>();
        for(String key : param.getParams().keySet()) {
            switch (key) {
                case "handleTime":
                case "endTime":
                    params.put(key+"Start", param.getParams().get(key).getValue().toString().split(",")[0] + " 00:00:00");
                    params.put(key+"End", param.getParams().get(key).getValue().toString().split(",")[1]+ " 23:59:59");
                    break;
                case "lockTypes":
                    params.put(key+"End", param.getParams().get(key).getValue().toString().split(","));
                    break;
                default:
                    params.put(key, param.getParams().get(key).getValue());
            }
            if("handleTime".equals(key)) {

            } else {

            }
        }
        params.put("searchText", param.getSearchText());
        List<CALockDetailVO> detailList = service.pageList(params);

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("CALockDetail-export.xlsx", beans, response);
    }

}
