package com.ejianc.business.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.asset.bean.PayReimburseDetailEntity;
/**
 * 资产管理-费用报销
 * 
 * @author generator
 * 
 */
 @TableName("ejc_asset_pay_reimburse")
public class PayReimburseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="depend_on_project")
    private String dependOnProject; // 属于项目:1-是，0-否
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bear_dept_id")
    private Long bearDeptId; // 费用承担部门id
    @TableField(value="bear_dept")
    private String bearDept; // 费用承担部门
    @TableField(value="pay_type")
    private Integer payType; // 付款类型：1-组织付款，2- 项目付款
    @TableField(value="pay_unit_id")
    private Long payUnitId; // 付款单位id
    @TableField(value="pay_unit_name")
    private String payUnitName; // 付款单位
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="apply_mny_cn")
    private String applyMnyCn; // 申请金额大写
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="reimburse_mmy")
    private BigDecimal reimburseMmy; // 报销费用（含本期）
    @TableField(value="cumulative_mny")
    private BigDecimal cumulativeMny; // 累计报销
    @TableField(value="pay_reason")
    private String payReason; // 报销事由
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="sub_fee_type_names")
    private String subFeeTypeNames; // 费用类别汇总(子表)
    @TableField(value="sub_fee_type_ids")
    private String subFeeTypeIds; // 费用类型ids
    @TableField(value="pay_status")
    private Integer payStatus; // 支付状态：1-未支付，2-已支付
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="reimburse_type")
    private Integer reimburseType; // 报销费用类型 1-项目管理 2-公司管理 3-资产管理
    
    @TableField(exist=false)
    @SubEntity(serviceName="payReimburseDetailService", pidName = "payapplyId")
    private List<PayReimburseDetailEntity> detailList = new ArrayList<>(); // 资产管理-费用报销子表

    public Integer getReimburseType() {
        return reimburseType;
    }

    public void setReimburseType(Integer reimburseType) {
        this.reimburseType = reimburseType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getBearDeptId() {
        return bearDeptId;
    }

    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }
    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }
    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public BigDecimal getReimburseMmy() {
        return reimburseMmy;
    }

    public void setReimburseMmy(BigDecimal reimburseMmy) {
        this.reimburseMmy = reimburseMmy;
    }
    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }

    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getSubFeeTypeNames() {
        return subFeeTypeNames;
    }

    public void setSubFeeTypeNames(String subFeeTypeNames) {
        this.subFeeTypeNames = subFeeTypeNames;
    }
    public String getSubFeeTypeIds() {
        return subFeeTypeIds;
    }

    public void setSubFeeTypeIds(String subFeeTypeIds) {
        this.subFeeTypeIds = subFeeTypeIds;
    }
    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }


    public List<PayReimburseDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PayReimburseDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
