package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.vo.CertRecordDetailImportVO;
import com.ejianc.business.oa.vo.CertRecordDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertRecordMapper;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.service.ICertRecordService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 人力行政-证书档案
 * 
 * @author generator
 * 
 */
@Service("certRecordService")
public class CertRecordServiceImpl extends BaseServiceImpl<CertRecordMapper, CertRecordEntity> implements ICertRecordService{

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<CertRecordDetailImportVO> successList = new ArrayList<>();
            List<CertRecordDetailImportVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 1000) {
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode("bfyj-oa-cert");
                if (!defDocByDefCode.isSuccess()){
                    throw new BusinessException("获取证书情况自定义档案失败！");
                }
                List<DefdocDetailVO> defdocList = defDocByDefCode.getData();
                Map<String, DefdocDetailVO> defDocMap = defdocList.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));

                Map<String, OrgVO> orgMap = new HashMap<>();

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    CertRecordDetailImportVO importVO = new CertRecordDetailImportVO();

                    //证照类别
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[证照类别为必填项]");
                    } else {
                        if (datas.get(0).length() > 200) {
                            importVO.setErrorMessage("填写证照类别长度为1~200字");
                        }
                        if (defDocMap.containsKey(datas.get(0).trim()))
                        importVO.setCertTypeName(datas.get(0).trim());
                        importVO.setCertType(defDocMap.get(datas.get(0).trim()).getId());
                    }

                    //证照名称
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[证照名称为必填项]");
                    } else {
                        if (datas.get(1).length() > 200) {
                            importVO.setErrorMessage("证照名称长度为1~200字");
                        }
                        importVO.setCertName(datas.get(1).trim());
                    }

                    //证照编号
                    if (StringUtils.isBlank(datas.get(2))) {
                        errorMessage.append("[证照编号为必填项]");
                    } else {
                        if (datas.get(2).length() > 50) {
                            importVO.setErrorMessage("填写证照编号长度为1~50字");
                        }
                        importVO.setCertCode(datas.get(2).trim());
                    }

                    //证书专业
                    if (StringUtils.isBlank(datas.get(3))) {
                        errorMessage.append("[证书专业为必填项]");
                    } else {

                        if (datas.get(3).length() > 50) {
                            importVO.setErrorMessage("填写证书专业长度为1~50字");
                        }
                        importVO.setCertCode(datas.get(3).trim());
                    }

                    importVO.setSealMajor(datas.get(4));
                    importVO.setAuthorities(datas.get(5));
                    importVO.setApproveNum(datas.get(6));

                    //生效日期
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importVO.setBeginTime(DateUtils.parseDate(datas.get(7), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[生效日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }else {
                        errorMessage.append("[生效日期为必填项]");
                    }

                    //有无期限
                    if (StringUtils.isBlank(datas.get(8))) {
                        errorMessage.append("[有无期限为必填项]");
                    } else {
                        importVO.setTermName(datas.get(8).trim());
                        importVO.setTerm("有".equals(datas.get(8).trim()) ? 1 : 2);
                    }

                    //失效日期
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            importVO.setEndTime(DateUtils.parseDate(datas.get(9), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[失效日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //电子证照有效期
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            importVO.setElectronCertDate(DateUtils.parseDate(datas.get(10), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[电子证照有效期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //发证日期
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            importVO.setSendCertDate(DateUtils.parseDate(datas.get(11), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[发证日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //加注有效期
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            importVO.setAddDate(DateUtils.parseDate(datas.get(12), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[加注有效期日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //证书使用状态
                    if (StringUtils.isNotBlank(datas.get(13))) {
                        importVO.setCertStateName(datas.get(13).trim());
                        importVO.setCertState("是".equals(datas.get(13).trim()) ? 1 : 2);
                    }

                    //存放地点
                    importVO.setPlace(datas.get(14));

                    //所属组织
                    if (StringUtils.isNotBlank(datas.get(15))){
                        if (orgMap.containsKey(datas.get(15))){
                            importVO.setOrgDetailId(orgMap.get(datas.get(15)).getId());
                            importVO.setOrgDetailName(orgMap.get(datas.get(15)).getName());
                        }else {
                            CommonResponse<OrgVO> orgResp = orgApi.findByNameAndTenantId(datas.get(15), InvocationInfoProxy.getTenantid());
                            if (!orgResp.isSuccess()){
                                throw new BusinessException("获取组织信息失败，请稍后重试！");
                            }
                            if (null != orgResp.getData()){
                                OrgVO orgVO = orgResp.getData();
                                orgMap.put(orgVO.getName(), orgVO);
                                importVO.setOrgDetailId(orgVO.getId());
                                importVO.setOrgDetailName(orgVO.getName());
                            }
                        }
                    }
                    importVO.setId(IdWorker.getId());


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    } else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
