package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.ProjectRegistrationEntity;
import com.ejianc.business.bid.constants.BidCommonContants;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.IProjectRegistrationService;
import com.ejianc.business.bid.vo.ProjectRegistrationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标管理-项目报名实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("projectRegistration")
public class ProjectRegistrationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BID-PROJECT-REGISTRATION";//此处需要根据实际修改

    @Autowired
    private IProjectRegistrationService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBusOpportunityService busOpportunityService;

    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-GP0J0k87";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<ProjectRegistrationVO> saveOrUpdate(@RequestBody ProjectRegistrationVO saveOrUpdateVO) {
    	ProjectRegistrationEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectRegistrationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            //默认待复核
            entity.setCheckStatus(BidCommonContants.CHECK_STATUS_UNCHECK);
            entity.setBillDate(new Date());
            entity.setFollowPerson(sessionManager.getUserContext().getEmployeeName());
            entity.setFollowPersonId(InvocationInfoProxy.getUserid());
        }
    	service.saveOrUpdate(entity, false);
    	ProjectRegistrationVO vo = BeanMapper.map(entity, ProjectRegistrationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ProjectRegistrationVO> queryDetail(Long id) {
    	ProjectRegistrationEntity entity = service.selectById(id);
    	ProjectRegistrationVO vo = BeanMapper.map(entity, ProjectRegistrationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<ProjectRegistrationVO> vos) {
        service.removeByIds(vos.stream().map(ProjectRegistrationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<ProjectRegistrationVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("area");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProjectRegistrationEntity> page = service.queryPage(param,false);
        IPage<ProjectRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectRegistrationVO> projectRegistrationVOS = BeanMapper.mapList(page.getRecords(), ProjectRegistrationVO.class);
        if (canUpdateAll()){
            projectRegistrationVOS.forEach(e -> {
                e.setUpdateCheckStatusFlag(1);
            });
        }

  		pageData.setRecords(projectRegistrationVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public Boolean canUpdateAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode())) return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("sectionName");
        fuzzyFields.add("area");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ProjectRegistrationEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectRegistration-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refProjectRegistrationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectRegistrationVO>> refProjectRegistrationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        //排除掉已被引用的
        List<BusOpportunityEntity> busList = busOpportunityService.getAllByRegistrationId(null, null);
        if(CollectionUtils.isNotEmpty(busList)) {
            param.getParams().put("id", new Parameter(QueryParam.NOT_IN,
                    new ArrayList<>(busList.stream().map(BusOpportunityEntity::getRegistrationId).collect(Collectors.toSet()))));
        }

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        //查询生效的
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        IPage<ProjectRegistrationEntity> page = service.queryPage(param,false);
        IPage<ProjectRegistrationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectRegistrationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @PostMapping(value = "checkBill")
    public CommonResponse<String> checkBill(@RequestBody Long billId) {
        ProjectRegistrationEntity entity = service.selectById(billId);
        if(null != entity.getBillState() && (entity.getBillState() == 1 || entity.getBillState() == 3) && BidCommonContants.CHECK_STATUS_CHECKED.equals(entity.getCheckStatus())) {
            return CommonResponse.error("操作失败，单据已复核！");
        }

        entity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        entity.setCheckStatus(BidCommonContants.CHECK_STATUS_CHECKED);
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(InvocationInfoProxy.getUsercode());
        entity.setCommitUserName(sessionManager.getUserContext().getUserName());
        entity.setEffectiveDate(new Date());

        service.saveOrUpdate(entity, false);

        return CommonResponse.success("操作成功！");
    }
}
