package com.ejianc.business.cost.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.vo.ProjectBillVO;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.ProjectBillEntity;

import java.util.List;

/**
 * 成本会计-项目对账单
 * 
 * @author generator
 * 
 */
public interface IProjectBillService extends IBaseService<ProjectBillEntity> {

    ProjectBillVO insertOrUpdate(ProjectBillVO saveOrUpdateVO);

    ProjectBillVO queryProjectBillDataByProjectId(String projectId, List<ProjectBillEntity> oldProjectBillEntityList);

    void removeDataByProjectBillId(Long id);

    List<ProjectDetailBillVO> pageList(Page<ProjectDetailBillVO> page, QueryWrapper<ProjectDetailBillVO> queryWrapper);

    List<InvoiceReceivePoolVO> queryCostDetailReport(Page<InvoiceReceivePoolVO> page, QueryWrapper<InvoiceReceivePoolVO> queryWrapper);
}
