package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.vo.ContractChangeVO;
import com.ejianc.business.oa.bean.EmployeeIntoEntity;
import com.ejianc.business.oa.service.IEmployeeIntoService;
import com.ejianc.business.oa.vo.EmployeeIntoChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.EmployeeIntoChangeMapper;
import com.ejianc.business.oa.bean.EmployeeIntoChangeEntity;
import com.ejianc.business.oa.service.IEmployeeIntoChangeService;

import java.util.Date;

/**
 * 人力行政-员工入职审批表-变更
 * 
 * @author generator
 * 
 */
@Service("employeeIntoChangeService")
public class EmployeeIntoChangeServiceImpl extends BaseServiceImpl<EmployeeIntoChangeMapper, EmployeeIntoChangeEntity> implements IEmployeeIntoChangeService{
    @Autowired
    private IEmployeeIntoService employeeIntoService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Override
    public EmployeeIntoChangeVO addConvertByEmpId(Long employeeId) {
        EmployeeIntoEntity vo = employeeIntoService.selectById(employeeId);
        EmployeeIntoChangeVO changeVO = BeanMapper.map(vo, EmployeeIntoChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setEmployeeId(changeVO.getId());
        changeVO.setChangeVersion(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(IdWorker.getId());
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(employeeId),"BT202411000023","photo", String.valueOf(changeVO.getId()), "BT202411000024","photo");

        return changeVO;
    }
}
