package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IReceiveService extends IBaseService<ReceiveEntity> {

    ReceiveVO insertOrUpdate(ReceiveVO receiveVO);

    ReceiveVO queryDetail(Long id);

    List<ReceiveVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

//    /**
//     * @description: 查询合同累计收款
//     *
//     * @param contractId
//     * @param receiveType 有则根据收入属性查询
//     * @return {@link SumReceiveVO}
//     * @author songlx
//     * @date: 2023/8/25
//     */
//    SumReceiveVO getSumReceiveVOList(Long contractId, Long receiveType);

    /**
     * 统计已生效的收入单据的收入金额
     *
     * @param tenantId 租户Id
     * @param projectIds 带过滤项目Id列表
     * @param isWithContract 是否有合同
     * @return
     */
    Map<String, Object> countRecAmt(Long tenantId, List<Long> projectIds,List<Long>orgIds, boolean isWithContract);

    List<ReceiveVO> queryProjectReceiveMny(List<Long> projectIds);

    List<ReceiveVO> queryInfoQuoteId(Long quoteId,Long contractId);

    ReceiveVO queryInfoContractId(Long contractId);

    List<ReceiveVO> queryTotalReceiveMny( List<Long> quoteIds);

//    List<ReceiveQuteDetailVO> getLastReceiveTaxMny(List<ReceiveQuteDetailVO> vos);

    ReceiveVO queryInfoProjectId(Long projectId);
}
