package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 人力行政-物品出库单子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_oa_outstore_detail")
public class OutstoreDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="out_store_id")
    private Long outStoreId; // 出库单主表id
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_spec")
    private String materialSpec; // 规格型号
    @TableField(value="material_unit")
    private String materialUnit; // 计量单位
    @TableField(value="out_store_number")
    private BigDecimal outStoreNumber; // 调拨数量/领料数量
    @TableField(value="residue_number")
    private BigDecimal residueNumber; // 剩可用数量（来源入库单子表）
    @TableField(value="detail_out_store_type")
    private Integer detailOutStoreType; // 出库单类型：0-调拨出库 1-出库单
    @TableField(value="source_main_id")
    private Long sourceMainId; // 数据来源主表id
    @TableField(value="source_sub_id")
    private Long sourceSubId; // 数据来源子表id
    @TableField(value="detail_in_store_id")
    private Long detailInStoreId; // 主表调入仓库id
    @TableField(value="detail_in_store_date")
    private Date detailInStoreDate; // 主表入库日期
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 单价
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="amount")
    private BigDecimal amount; // 金额
    @TableField(value="remark")
    private String remark; // 备注
    
    
    

    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    public BigDecimal getOutStoreNumber() {
        return outStoreNumber;
    }

    public void setOutStoreNumber(BigDecimal outStoreNumber) {
        this.outStoreNumber = outStoreNumber;
    }
    public BigDecimal getResidueNumber() {
        return residueNumber;
    }

    public void setResidueNumber(BigDecimal residueNumber) {
        this.residueNumber = residueNumber;
    }
    public Integer getDetailOutStoreType() {
        return detailOutStoreType;
    }

    public void setDetailOutStoreType(Integer detailOutStoreType) {
        this.detailOutStoreType = detailOutStoreType;
    }
    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }
    public Long getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(Long sourceSubId) {
        this.sourceSubId = sourceSubId;
    }
    public Long getDetailInStoreId() {
        return detailInStoreId;
    }

    public void setDetailInStoreId(Long detailInStoreId) {
        this.detailInStoreId = detailInStoreId;
    }
    public Date getDetailInStoreDate() {
        return detailInStoreDate;
    }

    public void setDetailInStoreDate(Date detailInStoreDate) {
        this.detailInStoreDate = detailInStoreDate;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
