package com.ejianc.business.invest.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目投资-个人还款
 * 
 * @author generator
 * 
 */
 @TableName("ejc_invest_person_repayment")
public class PersonRepaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="person_debt_id")
    private Long personDebtId; // 借款单id
    @TableField(value="person_debt_code")
    private String personDebtCode; // 借款单编码
    @TableField(value="debt_person_id")
    private Long debtPersonId; // 借款人
    @TableField(value="debt_person_name")
    private String debtPersonName; // 借款人名称
    @TableField(value="id_card")
    private String idCard; // 借款人身份证号
    @TableField(value="repayment_mny")
    private BigDecimal repaymentMny; // 还款金额
    @TableField(value="repayment_mny_str")
    private String repaymentMnyStr; // 还款金额大写
    @TableField(value="repayment_capital_mny")
    private BigDecimal repaymentCapitalMny; // 还款本金
    @TableField(value="repayment_interest_mny")
    private BigDecimal repaymentInterestMny; // 还款利息
    @TableField(value="total_interest_mny")
    private BigDecimal totalInterestMny; // 已还利息（不含本次）
    @TableField(value="interest_type")
    private String interestType; // 计息方式：取第一次项目借款单计息方式
    @TableField(value="interest_rate")
    private BigDecimal interestRate; // 利率 取第一次项目借款单利率
    @TableField(value="interest_rate_month")
    private String interestRateMonth; // 利率（按月计息），下拉选则，1-1分，2-2分，3-3分，即每月1%，2%，3%利息。
    @TableField(value="interest_start_date")
    private Date interestStartDate; // 利息开始日期
    @TableField(value="handle_date")
    private Date handleDate; // 办理日期
    @TableField(value="total_debt_mny")
    private BigDecimal totalDebtMny; // 累计借款金额（本项目累计借款金额合计）
    @TableField(value="total_repayment_mny")
    private BigDecimal totalRepaymentMny; // 累计还款金额（本项目累计还款金额合计）
    @TableField(value="total_debt_residue_mny")
    private BigDecimal totalDebtResidueMny; // 累计借款结余（累计借款本金-累计还款本金）
    @TableField(value="account_id")
    private Long accountId; // 收款账户
    @TableField(value="account_name")
    private String accountName; // 账户名
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="all_interest_mny")
    private BigDecimal allInterestMny; // 利息总额
    @TableField(value="remain_interest_mny")
    private BigDecimal remainInterestMny; // 剩余利息
    @TableField(value="last_handle_date")
    private Date lastHandleDate; // 上次办理日期


    public BigDecimal getRemainInterestMny() {
        return remainInterestMny;
    }

    public void setRemainInterestMny(BigDecimal remainInterestMny) {
        this.remainInterestMny = remainInterestMny;
    }

    public Date getLastHandleDate() {
        return lastHandleDate;
    }

    public void setLastHandleDate(Date lastHandleDate) {
        this.lastHandleDate = lastHandleDate;
    }

    public BigDecimal getAllInterestMny() {
        return allInterestMny;
    }

    public void setAllInterestMny(BigDecimal allInterestMny) {
        this.allInterestMny = allInterestMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getPersonDebtId() {
        return personDebtId;
    }

    public void setPersonDebtId(Long personDebtId) {
        this.personDebtId = personDebtId;
    }
    public String getPersonDebtCode() {
        return personDebtCode;
    }

    public void setPersonDebtCode(String personDebtCode) {
        this.personDebtCode = personDebtCode;
    }
    public Long getDebtPersonId() {
        return debtPersonId;
    }

    public void setDebtPersonId(Long debtPersonId) {
        this.debtPersonId = debtPersonId;
    }
    public String getDebtPersonName() {
        return debtPersonName;
    }

    public void setDebtPersonName(String debtPersonName) {
        this.debtPersonName = debtPersonName;
    }
    public BigDecimal getRepaymentMny() {
        return repaymentMny;
    }

    public void setRepaymentMny(BigDecimal repaymentMny) {
        this.repaymentMny = repaymentMny;
    }
    public String getRepaymentMnyStr() {
        return repaymentMnyStr;
    }

    public void setRepaymentMnyStr(String repaymentMnyStr) {
        this.repaymentMnyStr = repaymentMnyStr;
    }
    public BigDecimal getRepaymentCapitalMny() {
        return repaymentCapitalMny;
    }

    public void setRepaymentCapitalMny(BigDecimal repaymentCapitalMny) {
        this.repaymentCapitalMny = repaymentCapitalMny;
    }
    public BigDecimal getRepaymentInterestMny() {
        return repaymentInterestMny;
    }

    public void setRepaymentInterestMny(BigDecimal repaymentInterestMny) {
        this.repaymentInterestMny = repaymentInterestMny;
    }
    public BigDecimal getTotalInterestMny() {
        return totalInterestMny;
    }

    public void setTotalInterestMny(BigDecimal totalInterestMny) {
        this.totalInterestMny = totalInterestMny;
    }
    public String getInterestType() {
        return interestType;
    }

    public void setInterestType(String interestType) {
        this.interestType = interestType;
    }
    public BigDecimal getInterestRate() {
        return interestRate;
    }

    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }
    public String getInterestRateMonth() {
        return interestRateMonth;
    }

    public void setInterestRateMonth(String interestRateMonth) {
        this.interestRateMonth = interestRateMonth;
    }
    public Date getInterestStartDate() {
        return interestStartDate;
    }

    public void setInterestStartDate(Date interestStartDate) {
        this.interestStartDate = interestStartDate;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public BigDecimal getTotalDebtMny() {
        return totalDebtMny;
    }

    public void setTotalDebtMny(BigDecimal totalDebtMny) {
        this.totalDebtMny = totalDebtMny;
    }
    public BigDecimal getTotalRepaymentMny() {
        return totalRepaymentMny;
    }

    public void setTotalRepaymentMny(BigDecimal totalRepaymentMny) {
        this.totalRepaymentMny = totalRepaymentMny;
    }
    public BigDecimal getTotalDebtResidueMny() {
        return totalDebtResidueMny;
    }

    public void setTotalDebtResidueMny(BigDecimal totalDebtResidueMny) {
        this.totalDebtResidueMny = totalDebtResidueMny;
    }
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
}
