package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-开票申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_open_apply")
public class InvoiceOpenApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 申请单号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 合同开工日期
    @TableField(value="finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 合同竣工日期
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额
    @TableField(value="project_progress")
    private String projectProgress; // 工程进度(%)
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="invoice_bases")
    private Long invoiceBases; // 开票依据
    @TableField(value="invoice_bases_name")
    private String invoiceBasesName; // 开票依据
    @TableField(value="invoice_type")
    private Long invoiceType; // 发票类型
    @TableField(value="invoice_type_name")
    private String invoiceTypeName; // 发票类型
    @TableField(value="tax_type")
    private Long taxType; // 计税方式
    @TableField(value="tax_type_name")
    private String taxTypeName; // 计税方式
    @TableField(value="buyer_id")
    private Long buyerId; // 购方id（客户档案）
    @TableField(value="buyer_name")
    private String buyerName; // 购方名称
    @TableField(value="buyer_tax_id")
    private String buyerTaxId; // 购方纳税人识别号
    @TableField(value="buyer_bank_account")
    private String buyerBankAccount; // 购方开户银行及账号
    @TableField(value="buyer_addr_phone")
    private String buyerAddrPhone; // 购方地址及电话
    @TableField(value="invoice_info")
    private String invoiceInfo; // 发票内容
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额（不含税）
    @TableField(value="apply_mny_tax")
    private BigDecimal applyMnyTax; // 申请金额 含税
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="apply_mny_tax_chn")
    private String applyMnyTaxChn; // 申请金额 含税大写
    @TableField(value="tax")
    private BigDecimal tax; // 税金
    @TableField(value="applyer_id")
    private Long applyerId; // 申请人id
    @TableField(value="applyer_name")
    private String applyerName; // 申请人名称
    @TableField(value="apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="open_type")
    private Integer openType; // 0--未开票 1--已开票
    
    
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getProjectProgress() {
        return projectProgress;
    }

    public void setProjectProgress(String projectProgress) {
        this.projectProgress = projectProgress;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getInvoiceBases() {
        return invoiceBases;
    }

    public void setInvoiceBases(Long invoiceBases) {
        this.invoiceBases = invoiceBases;
    }
    public String getInvoiceBasesName() {
        return invoiceBasesName;
    }

    public void setInvoiceBasesName(String invoiceBasesName) {
        this.invoiceBasesName = invoiceBasesName;
    }
    public Long getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public Long getTaxType() {
        return taxType;
    }

    public void setTaxType(Long taxType) {
        this.taxType = taxType;
    }
    public String getTaxTypeName() {
        return taxTypeName;
    }

    public void setTaxTypeName(String taxTypeName) {
        this.taxTypeName = taxTypeName;
    }
    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    public String getBuyerTaxId() {
        return buyerTaxId;
    }

    public void setBuyerTaxId(String buyerTaxId) {
        this.buyerTaxId = buyerTaxId;
    }
    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }
    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }
    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getApplyMnyTax() {
        return applyMnyTax;
    }

    public void setApplyMnyTax(BigDecimal applyMnyTax) {
        this.applyMnyTax = applyMnyTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getApplyMnyTaxChn() {
        return applyMnyTaxChn;
    }

    public void setApplyMnyTaxChn(String applyMnyTaxChn) {
        this.applyMnyTaxChn = applyMnyTaxChn;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public Long getApplyerId() {
        return applyerId;
    }

    public void setApplyerId(Long applyerId) {
        this.applyerId = applyerId;
    }
    public String getApplyerName() {
        return applyerName;
    }

    public void setApplyerName(String applyerName) {
        this.applyerName = applyerName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getOpenType() {
        return openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }
    
}
