/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.mapper.CertRecordMapper;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.vo.CertRecordDetailImportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="certRecordService")
public class CertRecordServiceImpl
extends BaseServiceImpl<CertRecordMapper, CertRecordEntity>
implements ICertRecordService {
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CertRecordDetailImportVO> successList = new ArrayList<CertRecordDetailImportVO>();
        ArrayList<CertRecordDetailImportVO> errorList = new ArrayList<CertRecordDetailImportVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 16) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode("bfyj-oa-cert");
            if (!defDocByDefCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u8bc1\u4e66\u60c5\u51b5\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff01");
            }
            List defdocList = (List)defDocByDefCode.getData();
            Map<String, DefdocDetailVO> defDocMap = defdocList.stream().collect(Collectors.toMap(e -> e.getName(), e -> e));
            HashMap<String, OrgVO> orgMap = new HashMap<String, OrgVO>();
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                CertRecordDetailImportVO importVO = new CertRecordDetailImportVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errorMessage.append("[\u8bc1\u7167\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(0)).length() > 200) {
                        importVO.setErrorMessage("\u586b\u5199\u8bc1\u7167\u7c7b\u522b\u957f\u5ea6\u4e3a1~200\u5b57");
                    }
                    if (defDocMap.containsKey(((String)datas.get(0)).trim())) {
                        importVO.setCertTypeName(((String)datas.get(0)).trim());
                        importVO.setCertType(defDocMap.get(((String)datas.get(0)).trim()).getId());
                    } else {
                        importVO.setErrorMessage("\u8bf7\u5728\u8bc1\u4e66\u60c5\u51b5\u6863\u6848\u6dfb\u52a0\u8be5\u9879\uff01");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u8bc1\u7167\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(1)).length() > 200) {
                        importVO.setErrorMessage("\u8bc1\u7167\u540d\u79f0\u957f\u5ea6\u4e3a1~200\u5b57");
                    }
                    importVO.setCertName(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    errorMessage.append("[\u8bc1\u7167\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(2)).length() > 50) {
                        importVO.setErrorMessage("\u586b\u5199\u8bc1\u7167\u7f16\u53f7\u957f\u5ea6\u4e3a1~50\u5b57");
                    }
                    importVO.setCertCode(((String)datas.get(2)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    errorMessage.append("[\u8bc1\u4e66\u4e13\u4e1a\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(3)).length() > 50) {
                        importVO.setErrorMessage("\u586b\u5199\u8bc1\u4e66\u4e13\u4e1a\u957f\u5ea6\u4e3a1~50\u5b57");
                    }
                    importVO.setCertMajor(((String)datas.get(3)).trim());
                }
                importVO.setSealMajor((String)datas.get(4));
                importVO.setAuthorities((String)datas.get(5));
                importVO.setApproveNum((String)datas.get(6));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        importVO.setBeginTime(DateUtils.parseDate((String)((String)datas.get(7)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e2) {
                        errorMessage.append("[\u751f\u6548\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e2.printStackTrace();
                    }
                } else {
                    errorMessage.append("[\u751f\u6548\u65e5\u671f\u4e3a\u5fc5\u586b\u9879]");
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    errorMessage.append("[\u6709\u65e0\u671f\u9650\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    importVO.setTermName(((String)datas.get(8)).trim());
                    importVO.setTerm(Integer.valueOf("\u6709".equals(((String)datas.get(8)).trim()) ? 1 : 2));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    try {
                        importVO.setEndTime(DateUtils.parseDate((String)((String)datas.get(9)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e3) {
                        errorMessage.append("[\u5931\u6548\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e3.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    try {
                        importVO.setElectronCertDate(DateUtils.parseDate((String)((String)datas.get(10)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e4) {
                        errorMessage.append("[\u7535\u5b50\u8bc1\u7167\u6709\u6548\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e4.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    try {
                        importVO.setSendCertDate(DateUtils.parseDate((String)((String)datas.get(11)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e5) {
                        errorMessage.append("[\u53d1\u8bc1\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e5.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12)))) {
                    try {
                        importVO.setAddDate(DateUtils.parseDate((String)((String)datas.get(12)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e6) {
                        errorMessage.append("[\u52a0\u6ce8\u6709\u6548\u671f\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e6.printStackTrace();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    importVO.setCertStateName(((String)datas.get(13)).trim());
                    importVO.setCertState(Integer.valueOf("\u662f".equals(((String)datas.get(13)).trim()) ? 1 : 2));
                }
                importVO.setPlace((String)datas.get(14));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15)))) {
                    if (orgMap.containsKey(datas.get(15))) {
                        importVO.setOrgDetailId(((OrgVO)orgMap.get(datas.get(15))).getId());
                        importVO.setOrgDetailName(((OrgVO)orgMap.get(datas.get(15))).getName());
                    } else {
                        CommonResponse orgResp = this.orgApi.findByNameAndTenantId((String)datas.get(15), InvocationInfoProxy.getTenantid());
                        if (!orgResp.isSuccess()) {
                            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        }
                        if (null != orgResp.getData()) {
                            OrgVO orgVO = (OrgVO)orgResp.getData();
                            orgMap.put(orgVO.getName(), orgVO);
                            importVO.setOrgDetailId(orgVO.getId());
                            importVO.setOrgDetailName(orgVO.getName());
                        }
                    }
                }
                importVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

