package com.ejianc.business.project.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目基本信息管理-项目立项
 * 
 * @author generator
 * 
 */
 @TableName("ejc_project_register")
public class ProjectRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 项目编号
    @TableField(value="name")
    private String name; // 项目名称
    @TableField(value = "short_name")
    private String shortName; //项目简称
    @TableField(value="registration_id")
    private Long registrationId; // 项目报名表Id
    @TableField(value="opportunity_id")
    private Long opportunityId; // 商机登记表Id
    @TableField(value="opportunity_bill_code")
    private Long opportunityBillCode; // 商机登记单据编码
    @TableField(value="affirm_id")
    private Long affirmId; // 项目登记确认单Id
    @TableField(value="affirm_bill_code")
    private String affirmBillCode; // 项目登记确认单编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织Id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="status")
    private String status; // 项目状态：1-未开工, 2-在建，3-完成
    @TableField(value="valid_status")
    private String validStatus; // 项目停用状态：0-启用，1-停用
    @TableField(value="type")
    private String type; // 项目类型：1-自营，2-联营
    @TableField(value="regist_date")
    private Date registDate; // 立项日期
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value = "contractual_model_name")
    private String contractualModelName; // 承包模式名称
    @TableField(value="pub_unit")
    private Long pubUnit; // 发包单位
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 承包单位
    @TableField(value="province_id")
    private Long provinceId; // 所属省份Id
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类型
    @TableField(value="info_source")
    private Long infoSource; // 信息来源
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="investor")
    private Long investor; // 投资主体
    @TableField(value="bid_date")
    private Date bidDate; // 中标日期
    @TableField(value="bid_mny")
    private BigDecimal bidMny; // 中标金额(元)
    @TableField(value="planned_commencement_date")
    private Date plannedCommencementDate; // 计划开工日期
    @TableField(value="planned_finish_date")
    private Date plannedFinishDate; // 计划竣工日期
    @TableField(value="duration")
    private BigDecimal duration; // 计划工期
    @TableField(value="collection_type_name")
    private String collectionTypeName; // 征收方式及标准
    @TableField(value="other_fee")
    private String otherFee; // 其他收费项
    @TableField(value="structure_type")
    private Long structureType; // 结构类型
    @TableField(value="engineering_purpose")
    private Long engineeringPurpose; // 工程用途
    @TableField(value="project_manager")
    private Long projectManager; // 项目经理
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="tech_manager")
    private Long techManager; // 技术负责人/总工
    @TableField(value="follow_person_id")
    private Long followPersonId; // 业务经理
    @TableField(value="follow_person_name")
    private String followPersonName; // 业务经理名称
    @TableField(value="project_accounting_id")
    private Long projectAccountingId; // 项目会计
    @TableField(value="pub_flag")
    private Integer pubFlag; // 是否公示：0-否，1-是
    @TableField(value="belong_person_name")
    private String belongPersonName; // 项目所属人
    @TableField(value="tax_levy_rate")
    private BigDecimal taxLevyRate; // 税金征收率
    @TableField(value="management_fee_rate")
    private BigDecimal managementFeeRate; // 管理费征收率
    @TableField(value="no_cost_ticket_reserved_levy_rate")
    private BigDecimal noCostTicketReservedLevyRate; // 无成本票预留征收率
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期

    @TableField(value = "pub_unit_name")
    private String pubUnitName;//发包单位名称

    @TableField(value = "contractor_unit_name")
    private String contractorUnitName;//承包单位名称

    @TableField(value = "engineering_type_name")
    private String engineeringTypeName; //工程类型名称

    @TableField(value = "info_source_name")
    private String infoSourceName;//信息来源名称

    @TableField(value = "structure_type_name")
    private String structureTypeName;//结构类型名称

    @TableField(value = "engineering_purpose_name")
    private String engineeringPurposeName;// 工程用途名称

    @TableField(value = "project_department_id")
    private Long projectDepartmentId; //所属项目部Id
    @TableField(value = "project_department_code")
    private String projectDepartmentCode; //所属项目部编码
    @TableField(value = "project_department_name")
    private String projectDepartmentName; //所属项目部名称

    @TableField(exist=false)
    @SubEntity(serviceName="projectRegisterFileService")
    private List<ProjectRegisterFileEntity> detailList = new ArrayList<>(); // 项目基本信息管理-项目资料子实体

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentCode() {
        return projectDepartmentCode;
    }

    public void setProjectDepartmentCode(String projectDepartmentCode) {
        this.projectDepartmentCode = projectDepartmentCode;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getRegistrationId() {
        return registrationId;
    }

    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    public Long getOpportunityId() {
        return opportunityId;
    }

    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }

    public Long getAffirmId() {
        return affirmId;
    }

    public void setAffirmId(Long affirmId) {
        this.affirmId = affirmId;
    }

    public String getAffirmBillCode() {
        return affirmBillCode;
    }

    public void setAffirmBillCode(String affirmBillCode) {
        this.affirmBillCode = affirmBillCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }
    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }
    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    public Long getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }
    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }
    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }
    public BigDecimal getDuration() {
        return duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }
    public String getCollectionTypeName() {
        return collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }
    public String getOtherFee() {
        return otherFee;
    }

    public void setOtherFee(String otherFee) {
        this.otherFee = otherFee;
    }
    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }
    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public Long getTechManager() {
        return techManager;
    }

    public void setTechManager(Long techManager) {
        this.techManager = techManager;
    }
    public Long getFollowPersonId() {
        return followPersonId;
    }

    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    public Long getProjectAccountingId() {
        return projectAccountingId;
    }

    public void setProjectAccountingId(Long projectAccountingId) {
        this.projectAccountingId = projectAccountingId;
    }
    public Integer getPubFlag() {
        return pubFlag;
    }

    public void setPubFlag(Integer pubFlag) {
        this.pubFlag = pubFlag;
    }
    public String getBelongPersonName() {
        return belongPersonName;
    }

    public void setBelongPersonName(String belongPersonName) {
        this.belongPersonName = belongPersonName;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public BigDecimal getManagementFeeRate() {
        return managementFeeRate;
    }

    public void setManagementFeeRate(BigDecimal managementFeeRate) {
        this.managementFeeRate = managementFeeRate;
    }
    public BigDecimal getNoCostTicketReservedLevyRate() {
        return noCostTicketReservedLevyRate;
    }

    public void setNoCostTicketReservedLevyRate(BigDecimal noCostTicketReservedLevyRate) {
        this.noCostTicketReservedLevyRate = noCostTicketReservedLevyRate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<ProjectRegisterFileEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProjectRegisterFileEntity> detailList) {
        this.detailList = detailList;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
}
