package com.ejianc.business.cost.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.vo.ProjectDetailBillVO;
import com.ejianc.business.cost.vo.ProjectReportVO;
import com.ejianc.business.tax.vo.InvoiceReceivePoolVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectBillVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 成本会计-项目对账单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectBill")
public class ProjectBillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_CBKJ_XMDZ";//此处需要根据实际修改

    @Autowired
    private IProjectBillService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectBillVO> saveOrUpdate(@RequestBody ProjectBillVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.insertOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectBillVO> queryDetail(Long id) {
    	ProjectBillEntity entity = service.selectById(id);
    	ProjectBillVO vo = BeanMapper.map(entity, ProjectBillVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectBillVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectBillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                service.removeDataByProjectBillId(vo.getId());
            }
        }
        service.removeByIds(vos.stream().map(ProjectBillVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectBillVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<ProjectBillEntity> page = service.queryPage(param,false);
        IPage<ProjectBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectBillVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectBillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ProjectBillVO> voList = BeanMapper.mapList(list, ProjectBillVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("ProjectBill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refProjectBillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectBillVO>> refProjectBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectBillEntity> page = service.queryPage(param,false);
        IPage<ProjectBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectBillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 根据项目id查询项目对账单关联单据的数据
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryProjectBillDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectBillVO> queryProjectBillDataByProjectId(String projectId, Long projectBillId) {
        QueryWrapper<ProjectBillEntity> queryWrapper = new QueryWrapper<ProjectBillEntity>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.notIn("bill_state", Arrays.asList(1, 3));
        if (null != projectBillId ){
            queryWrapper.ne("id", projectBillId);
        }
        queryWrapper.orderByDesc("create_time");
        List<ProjectBillEntity> entityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 0){
            throw new BusinessException("当前项目存在未生效的项目对账单！");
        }
        entityList = service.list(new QueryWrapper<ProjectBillEntity>().eq("project_id", projectId).in("bill_state", Arrays.asList(1, 3)).orderByDesc("create_time"));
        ProjectBillVO projectBillVO = service.queryProjectBillDataByProjectId(projectId, entityList);
        return CommonResponse.success("根据项目id查询信息数据成功！", projectBillVO);
    }

    /**
     * @Description 项目看板
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryProjectReportByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectReportVO> queryProjectReportByProjectId(Long projectId) {
        ProjectReportVO projectReportVO = service.queryProjectReportByProjectId(projectId);
        QueryWrapper<ProjectBillEntity> queryWrapper = new QueryWrapper<>();
        if (null != projectId){
            queryWrapper.eq("project_id", projectId);
        }
        queryWrapper.in("bill_state", Arrays.asList(1, 3));
        List<ProjectBillEntity> entityList = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entityList) && entityList.size() > 0){
            projectReportVO.setDifPlaceAdvanceTax(entityList.stream().filter(item -> null != item.getDifPlaceAdvanceTax()).map(ProjectBillEntity::getDifPlaceAdvanceTax).reduce(BigDecimal.ZERO, BigDecimal::add));
        }

        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        QueryWrapper<ProjectDetailBillVO> queryProjectWrapper = changeToQueryWrapper(param);
        Page<ProjectDetailBillVO> page = new Page<>(1, 10000);
        List<ProjectDetailBillVO> pageData = service.pageList(page, queryProjectWrapper);
        if (CollectionUtils.isNotEmpty(pageData) && pageData.size() > 0){
            BigDecimal balance = BigDecimal.ZERO;
            for (ProjectDetailBillVO data : pageData) {
                balance = ComputeUtil.safeSub(ComputeUtil.safeAdd(null != data.getReceiveMny() ? data.getReceiveMny() : BigDecimal.ZERO, balance), null != data.getPaymentMny() ? data.getPaymentMny() : BigDecimal.ZERO);
                data.setBalance(balance);
            }
            projectReportVO.setLeaveUsableCost(null != pageData && pageData.size() > 1 ? pageData.get(pageData.size() - 1).getBalance() : BigDecimal.ZERO);
        }
        return CommonResponse.success("查询项目看板数据成功！", projectReportVO);
    }


}
